#include "mbed.h"
//UART PINS (TX, RX, BAUDRATE)
Serial pc(PB_13, PB_12, 9600);
Serial pc2(PF_7, PF_6, 9600);

//CAN PINS (RX, TX)
CAN can(PA_11, PA_12);
CANMessage message;

void callback(){
    //UART RECEIVE
    char byte;
    pc.printf("callback");
    if(pc.readable()){
        byte = pc.getc();
        pc.printf("I received %c\n", byte);
    }
}

void callbackCAN(){
    //CAN RECEIVE
    can.read(message);
    //CAN SEND
    can.write(message);
}

int main(){
    //UART INIT
    //pc.attach(&callback);
    pc2.attach(&callback);
    
    //CAN INIT
    can.frequency(100000);
    can.attach(callbackCAN);
    
    while(1){
        //UART SEND
        pc2.printf("Hi Marta and Mina. I am ECU!\n");
        
        //CAN SEND
        message.id = 0x01;
        message.data[1] = 0x48; // repeat for each byte.
        can.write(message);
        
        wait(2);
        }
    
}