#include "mbed.h"
/////////PIN DEFINITION////////////
DigitalOut myled(LED1);
DigitalOut leftEmit(PC_15);
DigitalOut fLeftEmit(PC_14);
DigitalOut fRightEmit(PC_13);
DigitalOut rightEmit(PB_7);
AnalogIn leftRec(A3);
AnalogIn fLeftRec(A2);
AnalogIn fRightRec(A1);
AnalogIn rightRec(A0);

PwmOut LMOTORA(PB_4);
PwmOut LMOTORB(PB_10);
PwmOut RMOTORA(PB_6);
PwmOut RMOTORB(PA_7);
Serial pc(SERIAL_TX, SERIAL_RX); //TX=PA_2, RX=PA_3


InterruptIn LENCA(PC_1);
InterruptIn LENCB(PC_0);
InterruptIn RENCA(PA_15);
InterruptIn RENCB(PB_3);
InterruptIn mybutton(USER_BUTTON);

//////CONSTANTS///////////////////
int leftMiddleValue=100;
int rightMiddleValue=130;
int rlSensorOffset=30;
int flWallThresh=60; 
int frWallThresh=80; 
int lWallThresh=40;
int rWallThresh=60;

float leftBasePower=0.2;
float rightBasePower=0.2;

int nintyDegreeShift = 800;// to make a ninty degree turn
int stepShift = 1800;// to move a step
//////////PID//////////////////
float P=0.0015; 
float D=0.0;

float errorP=0; float errorD=0; float oldErrorP=0; float totalError=0;



int i = 0;
volatile unsigned long Lpulses = 0;
volatile unsigned long Rpulses = 0;
void incrementLeftEncoder() {Lpulses ++;}
void incrementRightEncoder() {Rpulses ++;}

void setLeftPwm(float speed)
{
    if (speed == 0){
        LMOTORA = 1.0;
        LMOTORB = 1.0;
    }    
    else if (speed < 0){  //!!!!!!
        LMOTORA = -speed;
        LMOTORB = 0;
    }
    else{
        LMOTORA = 0;
        LMOTORB = speed;
    }
}
    
void setRightPwm(float speed) {
    if (speed == 0) {
        RMOTORA = 1.0;
        RMOTORB = 1.0;
    }
    
    if (speed > 0) {
        RMOTORA = speed;
        RMOTORB = 0;
    }
    else {
        RMOTORA = 0;
        RMOTORB = -speed;
    }
}

void flipLED()
{
    myled=!myled;
    }
    
void pid()       
{    
    float left=leftRec.read()*1000;
    float right=rightRec.read()*1000;
    
    if((left > lWallThresh && right > rWallThresh))//has both walls
    {  //ccw direction is positive
        errorP = (right - left) - rlSensorOffset;
        errorD = errorP - oldErrorP;
    }        
    else if((left > lWallThresh)) //only has left wall
    {
        errorP = 1 * (leftMiddleValue - left);
        errorD = errorP - oldErrorP;
    }
    else if((right > rWallThresh))//only has right wall
    {
        errorP = 1* (right-rightMiddleValue);
        errorD = errorP - oldErrorP;
    }
    else if((left < lWallThresh && right <rWallThresh ))//no wall, use encoder or gyro
    {
        errorP = 0;//(leftEncoder – rightEncoder*1005/1000)*3;
        errorD = 0;
    }
    totalError = P * errorP + D * errorD;
    oldErrorP = errorP;
    setLeftPwm(leftBasePower - totalError);  setRightPwm(rightBasePower + totalError);
 
}

void sensorRead() //print sensor readings and wall detections
{
       while(1) {
        leftEmit=1; fLeftEmit=1; fRightEmit=1; rightEmit=1;
        wait(0.1);
        float left=leftRec.read()*1000; 
        float fLeft=fLeftRec.read()*1000; 
        float fRight=fRightRec.read()*1000;
        float right=rightRec.read()*1000; 
        //pc.printf("Shit loop%d!\r\n", i++);
        //pc.printf("Lpulses: %d | Rpulses: %d \r\n", Lpulses, Rpulses);
        pc.printf("left: %f     fLeft: %f    fRight: %f    right: %f   \r\n", left, fLeft, fRight, right);
        if(fLeft>flWallThresh || fRight>frWallThresh)   pc.printf("Wall Front!\r\n");
        if(left>lWallThresh )   pc.printf("Wall Left!\r\n");
        if(right>rWallThresh )   pc.printf("Wall Right!\r\n");
        leftEmit=0; fLeftEmit=0; fRightEmit=0; rightEmit=0;
        wait(0.5);
    }
}

void turn(int angle) // + means left, - means right
{
    //Lpulses = 0;
    //Rpulses = 0;
    int toTurn = abs(angle) * nintyDegreeShift / 90;
    int leftGoal = Lpulses + toTurn;
    int rightGoal = Rpulses + toTurn;
    if (angle > 0) {setRightPwm(0.2);setLeftPwm(-0.2);}
    if (angle < 0) {setRightPwm(-0.2);setLeftPwm(+0.2);}

    while ((rightGoal >= Rpulses) || (leftGoal >= Lpulses)){
        if (rightGoal < Rpulses){
            setRightPwm(0);
        }
        else if (leftGoal < Lpulses){
            setLeftPwm(0);
        }
        wait_ms(1);
    }
    setRightPwm(0); setLeftPwm(0);
}

void forward(float step)
{
    int toGo = step * stepShift;
    int leftGoal = Lpulses + toGo;
    int rightGoal = Rpulses + toGo;
    setRightPwm(0.2);setLeftPwm(0.2);

    while ((rightGoal >= Rpulses) || (leftGoal >= Lpulses)){
        if (rightGoal < Rpulses){
            setRightPwm(0);
        }
        else if (leftGoal < Lpulses){
            setLeftPwm(0);
        }
        wait_ms(1);
    }
    setRightPwm(0); setLeftPwm(0);
    
}
/*

void followerRun()
{
  int init=0;
  while(init==0)
  {
    if(fRightRec.read()*1000>80){
      pc.printf("Start!!!! \r\n");
      init=1;
      wait(5);
      setRightPwm(rightBasePower); setLeftPwm(leftBasePower);
      break;
    }
    wait_ms(5);    
  }
  
  if(fRightRec.read()*1000> 70  && fLeftRec.read()*1000 > 45 )
   {
     stop();
     delay(500);
     if(wallRight()==0)  //wall front, no right wall
     {
       turnRight();
       delay(200);
       setForward();
       rightTurnsCount++;
       if (roundTurnsCount >0) roundTurnsCount--;
     }
     else if(wallLeft()==0)  //wall front&right, no left wall
     {
       turnLeft();
       setForward();
       leftTurnsCount++;
       if (roundTurnsCount >0) roundTurnsCount--;
     }
     else    //wall front, right, left
     {
       turnRight();
       turnRight();
       setForward();
       if (roundTurnsCount >0) roundTurnsCount--;
     }
       
   }
   else
      pid();
     
     
     //in case go back and forth 
      if (roundTurnsCount >=3)
      {
        if(leftSensor() < lWallThresh + 20)   //no wall on left
  {
      delay(500);
    stop();
    delay(500);
    turnLeft();
    delay(500); //debug
    //forward();
    setForward();
    delay(400);
  }
  roundTurnsCount = 0;
      }
      
}

*/

void leftFollower()
{
  int init=0;
  while(init==0)
  {
    if(fRightRec.read()*1000>80){
      pc.printf("Start!!!! \r\n");
      init=1;
      wait(5);
      setRightPwm(rightBasePower); setLeftPwm(leftBasePower);
      break;
    }
    wait_ms(5);    
  }
  
  while(1) {
  if(leftRec.read()*1000 < lWallThresh + 0)   //no wall on left
  {
    pc.printf("Turn left! \r\n");
    setRightPwm(0); setLeftPwm(0);
    wait(1);   //debug, half step + left turn + half step
    forward(0.5);
    turn(90);  
    forward(0.5);
  }
  else if(fLeftRec.read()*1000 > flWallThresh + 0)  //walls in front and left 
  {
    pc.printf("Turn right! \r\n");
    setRightPwm(0); setLeftPwm(0);
    wait(1);  
    turn(-90);
  }
  else {
    pc.printf("Stay straight!!! \r\n");
    pid();   //wall on left but no wall in front
    wait_ms(5);
    }
  }
 
 }


int main() {
    myled = 0;
    //setup interrupts to read encoder signals! Lpulses and Rpulses are the readings!
    LENCA.rise(&incrementLeftEncoder);  LENCA.fall(&incrementLeftEncoder);
    LENCB.rise(&incrementLeftEncoder);  LENCB.fall(&incrementLeftEncoder);
    RENCA.rise(&incrementRightEncoder); RENCA.fall(&incrementRightEncoder);
    RENCB.rise(&incrementRightEncoder); RENCB.fall(&incrementRightEncoder);
    mybutton.rise(&flipLED);
    
    setLeftPwm(0); 
    setRightPwm(0);
    leftEmit=1; fLeftEmit=1; fRightEmit=1; rightEmit=1;
    
    while(1)
    {
        forward(1);
        wait(1);
        }
    //sensorRead();
    //leftFollower();
    
    /*while(1){
        pc.printf("Lpulses: %d | Rpulses: %d \r\n", Lpulses, Rpulses);
       sensorRead();
     }*/
     /*
      turn(90);
        wait(1);
        forward(1);
        wait(1);
        */
    //sensorRead();
    
   /* while(1) {
        setLeftPwm(1); 
        setRightPwm(1);
        leftEmit=1; //wait(1.0); 
        float left=leftRec.read(); //leftEmit=0; 
        fLeftEmit=1; //wait(1.0); 
        float fLeft=fLeftRec.read(); //fLeftEmit=0; 
        fRightEmit=1; //wait(1.0); 
        float fRight=fRightRec.read(); //fRightEmit=0; 
        rightEmit=1; //wait(1.0); 
        float right=rightRec.read(); //rightEmit=0; 
        wait(1.0);
        //pc.printf("Shit loop%d!\r\n", i++);
        //pc.printf("Lpulses: %d | Rpulses: %d \r\n", Lpulses, Rpulses);
        pc.printf("left: %f     fLeft: %f    fRight: %f    right: %f   \r\n", left*100, fLeft*100, fRight*100, right*100);
        
        leftEmit=0; fLeftEmit=0; fRightEmit=0; rightEmit=0;
        wait(1.0);
    }*/
}
