#include "mbed.h"

#include "SenseClient.h"
#include "EthernetNetIf.h"
#include "picojson.h"



// sen.se client
SenseClient sense("your sen.se key", "your http proxy or empty string");
// update your IDs
string deviceID = "5136";
string feedID = "13309";
string actionfeedID = "13310";

// ethernet network interface for ip stack
EthernetNetIf eth;

DigitalOut led1(LED1);
DigitalOut led4(LED4);

// just a post sample
void postEvent() {
    picojson::object v;
    v["aa"] = picojson::value(string("tt"));
    v["bb"] = picojson::value(double(1.66));
    string str = picojson::value(v).serialize();
    // if you want to send your data as a json value,
    // you have to know that it is in fact a string inside another json
    // so it needs to be escaped as any json string
    string escapedStr = picojson::value(str).serialize();

    sense.PostEvent(feedID, escapedStr);

    if (sense.Result() == HTTP_OK) {
        printf("Success PostEvent()!\r\n");

        if (sense.ResponseContent().get().compare("null") != 0) {
        picojson::value v2;
        const char* response = sense.ResponseContent().gets();
        printf("http response content: %s\r\n", response);
        string err = picojson::parse(v2, response, response + strlen(response));
        printf("--> res error: %s\r\n", err.c_str());
        printf("--> res isarray: %d\r\n", v2.is<picojson::array>());

        printf("--> res date: %s\r\n", v2.get(0).get("timetag").get<string>());
        } else {
            printf("No events found\r\n");
        }
    } else {
        printf("Sen.se result  / response code : %d / %d\r\n", sense.Result(), sense.Response());
    }
}

// get last event call
void getLastEvent() {
    sense.GetLastFeedEvent(feedID);

    if (sense.Result() == HTTP_OK) {
        printf("Success LastFeedEvent()!\r\n");

        
        
        if (sense.ResponseContent().get().compare("null") != 0) {
            picojson::value v2;
            const char* response = sense.ResponseContent().gets();
            printf("http response content: '%s'\r\n", sense.ResponseContent().get());
            string err = picojson::parse(v2, response, response + strlen(response));
            printf("--> res error: %s\r\n", err.c_str());
            const char* s = v2.get("value").get<string>().c_str();
            printf("value content: %s\r\n", s);
            picojson::value v3;
            string err2 = picojson::parse(v3, s, s + strlen(s));
            printf("--> res error: %s\r\n", err2.c_str());
        } else {
            printf("No events found\r\n");
        }

    } else {
        printf("Sen.se result  / response code : %d / %d\r\n", sense.Result(), sense.Response());
    }
}

// get device last event call
void getDeviceLastEvent() {
    sense.GetDeviceLastEvent(deviceID);

    if (sense.Result() == HTTP_OK) {
        printf("Success LastDeviceEvent()!\r\n");

        if (sense.ResponseContent().get().compare("null") != 0) {
        picojson::value v2;
        const char* response = sense.ResponseContent().gets();
        printf("http response content: %s\r\n", response);
        string err = picojson::parse(v2, response, response + strlen(response));
        printf("--> res error: %s\r\n", err.c_str());
        } else {
            printf("No events found\r\n");
        }

    } else {
        printf("Sen.se result  / response code : %d / %d\r\n", sense.Result(), sense.Response());
    }

}

//
// This function MUST be defined with that definition in order to have the server working as it is defined as the following
// in the SenseClient.SenseHandler class:
//
// extern void parseEvent(char* content);
//
void parseEvent(char* content) {
    led4 = !led4;   // update led when we recieve a message from the server
    printf("content: %s\r\n", content);
    char* value = sense.getParam(content, "value");
    printf("value: %s\r\n", value);
    
    picojson::value v;
    string err = picojson::parse(v, value, value + strlen(value));
    printf("--> res error: %s\r\n", err.c_str());
    
    const char* s = v.get("track").get<string>().c_str();
    printf("track content: %s\r\n", s);
}

int main() {

    // setup the network interface (by dhcp)
    printf("Setuping ethernet!\r\n");
    int status = eth.setup();

    if (status == ETH_OK) {
        IpAddr ethIp = eth.getIp();
        printf("Connected ok, IP : %d.%d.%d.%d\r\n", ethIp[0], ethIp[1], ethIp[2], ethIp[3]);

        //testJSON();
        //parseJSON();
        //sense.PostEvent("4293", "value as json string or string");
        //picojson::object root;
        /*object root;
        root["test"] = picojson::value(string("param"));

        picojson::value v1(root);
        string jsonres = v1.serialize();

        printf("   serialized %s\r\n", jsonres.c_str());
        //string jsonres = "dsqd";

        sense.PostEvent("4293", jsonres);*/

        /*picojson::object json;
        json["test"] = picojson::value(string("param"));*/

        //postEvent();
        getLastEvent(); // a test to get the last event
        //getDeviceLastEvent();

        // start the http server on port 8080
        sense.startHttpServer(8080);
        
        
        Timer tm;
        tm.start();
        //Listen indefinitely
        while (true) {
            Net::poll();
            if (tm.read()>.5) {
                led1=!led1; //Show that we are alive
                tm.start();
            }
        }

    } else {
        printf("Unable to get IP\r\n");
    }


}
