#include "SenseHandler.h"


SenseHandler::SenseHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket) {}

SenseHandler::~SenseHandler() {}



void SenseHandler::doGet() {
    printf("doGet called\r\n");
    const char* resp = "Hello world !";
    setContentLen( strlen(resp) );
    respHeaders()["Connection"] = "close";
    writeData(resp, strlen(resp));
}

void SenseHandler::doPost() {
    printf("doPost called\r\n");
    int len = dataLen();
    //string path = path();
    //string rootPath = rootPath();
    //readData(char* buf, int len);
    //respHeaders()["Connection"] = "close";
    //setContentLen(100);
    //setErrCode(404);
    onReadable();
}

void SenseHandler::doHead() {

}


void SenseHandler::onReadable() { //Data has been read
    printf("onReadable called\r\n");
    int _datalen = dataLen();   //read POST data length

    //allocate size of readable data
    char* _send_data = (char *) malloc(sizeof(char) * _datalen + 1);

    //read POST data
    readData(_send_data, _datalen);

    //char myName[100] = ""; 
    //getParam("value", myName);
    //process POST data here, you can call any subroutine from here
    //printf("value: %s\r\n", myName);
    
    //write any response header
    respHeaders()["Connection"] = "close";

    //http_response contains any html code as my reply
    //writeData(http_response, strlen(http_response));
    _send_data[_datalen] = '\0';
    parseEvent(_send_data);

}

void SenseHandler::onWriteable() { //Data has been written & buf is free
    close(); //Data written, we can close the connection
}

void SenseHandler::onClose() { //Connection is closing
    //Nothing to do
}


