/*
   Copyright [2011] [mimilowns@gmail.com]

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
#include "SenseClient.h"
#include "HTTPClient.h"



SenseClient::SenseClient(const string& senseKey, const string& httpproxy) :  _jsonContent("application/json"), _jsonRespContent("application/json") {


    _key = senseKey;
    _proxy = httpproxy;

}

SenseClient::~SenseClient() {
}

void SenseClient::PostEvent(const string& feedID, const string& value) {
    _jsonContent.set("{\"feed_id\":"+feedID+", \"value\":"+value+"}");

    string uri = "http://api.sen.se/event_api/events/";
    HTTPClient _client;
    _client.setRequestHeader("sense_key", _key);
    if (!_proxy.empty()) {
        _client.setProxy(_proxy.c_str());
    }

    _result = _client.post(uri.c_str(), _jsonContent, &_jsonRespContent);
    _response = _client.getHTTPResponseCode();
}

void SenseClient::GetLastFeedEvent(const string& feedID) {
    string uri = "http://api.sen.se/event_api/feeds/"+feedID+"/last_event/";

    HTTPClient _client;
    _client.setRequestHeader("sense_key", _key);
    if (!_proxy.empty()) {
        _client.setProxy(_proxy.c_str());
    }

    _result = _client.get(uri.c_str(), &_jsonRespContent);
    _response = _client.getHTTPResponseCode();
}

void SenseClient::GetDeviceLastEvent(const string& deviceID) {
    string uri = "http://api.sen.se/devices/"+deviceID+"/last_event/";

    HTTPClient _client;
    _client.setRequestHeader("sense_key", _key);
    if (!_proxy.empty()) {
        _client.setProxy(_proxy.c_str());
    }

    _result = _client.get(uri.c_str(), &_jsonRespContent);
    _response = _client.getHTTPResponseCode();
}

/**
* Returns the given parameter value identified by its name from the given http query string.
*
* @return The parameter value 
* @param queryString The http query string
* @param name The parameter name
*/
char* SenseClient::getParam(char *queryString, const char *name) {
    char *pos1 = strstr(queryString, name);

    if (pos1) {
        pos1 += strlen(name);

        if (*pos1 == '=') { // Make sure there is an '=' where we expect it
            pos1++;

            // compute the size of the buffer
            char *pos2 = pos1;
            while (*pos2 && *pos2 != '&') {
                pos2++;
            }
            char* value = (char *) malloc(sizeof(char) * (pos2-pos1+1));
            char* ret = value;

            // store the string in the buffer

            while (*pos1 && *pos1 != '&') {
                if (*pos1 == '%') { // Convert it to a single ASCII character and store at our Value
                    *value++ = (char)ToHex(pos1[1]) * 16 + ToHex(pos1[2]);
                    pos1 += 3;
                } else if ( *pos1=='+' ) { // If it's a '+', store a space at our Valueination
                    *value++ = ' ';
                    pos1++;
                } else {
                    *value++ = *pos1++; // Otherwise, just store the character at our Value
                }
            }

            *value++ = '\0';
            return ret;
        }

    }

    return NULL;
}

/**
* Starts an http server to receive messages from sen.se platform. A function void parseEvent(char* content) MUST be defined in your main.
*
* @param port The port on which to start the http server
*/
void SenseClient::startHttpServer(int port) {

    _svr.addHandler<SenseHandler>("/");
    _svr.bind(port);

    printf("Listening on port %d...\r\n", port);

}

// http result and response
HTTPResult SenseClient::Result() {
    return _result;
}
int SenseClient::Response() {
    return _response;
}

HTTPText SenseClient::ResponseContent() {
    return _jsonRespContent;
}
