#include "sys.h"
#include "sd_card.h"
#include "fat_lib.h"
#include "pwm_lib.h"
#include "wave_player_main.h"

 /* SD card pin
 Pin side
 --------------\
         9     = \    DAT2/NC
             1 ===|   CS/DAT3    [CS]
             2 ===|   CMD/DI     [DI]
             3 ===|   VSS1
 Bottom      4 ===|   VDD
 View        5 ===|   CLK        [CLK]
             6 ===|   VSS2
             7 ===|   DO/DAT0    [DO]
         8       =|   DAT1/IRQ
 -----------------

                                         Arduino      NUCLEO-F411       NUCLEO-F030R8
 Logo side
 -----------------
         8       =|   DAT1/IRQ
             7 ===|   DO/DAT0    [DO]     D12           D12/PA_6           D12/PA_6
             6 ===|   VSS2
 Top         5 ===|   CLK        [CLK]    D13           D13/PA_5           D13/PA_5
 View        4 ===|   VDD
             3 ===|   VSS1
             2 ===|   CMD/DI     [DI]     D11           D11/PA_7           D11/PA_7
             1 ===|   CS/DAT3    [CS]     D8            D10/PB_6           D10/PB_6
         9     = /    DAT2/NC
 --------------/
 */

#if UART_INFO && DEVICE_SERIAL
RawSerial pc(USBTX,USBRX);
#endif

int main() {
#if UART_INFO && DEVICE_SERIAL
    setbuf(stdout,0);
    pc.baud(115200);
#endif
    wait_us(100*1000); /* wait 100msec */
    pwm_init();
    sd_init();
    FAT_init();
    wave_player_main();
}


void error(const char* format, ...) { }
