#ifndef __PWM_LIB_H__
#define __PWM_LIB_H__

#include "sys.h"
#include "FastPWM.h"

/*
 * PWM Timer interrupt module
 * */
#if defined(TIM3)
#   define TIM_PWM      TIM3
#   define TIM_PWM_IRQ  TIM3_IRQn
#else
#   error Edit this file properly !
#endif

#define TPWM                        FastPWM
//#define TPWM                        PwmOut
#define PWM_TIMER_PRE_SCALE         1
#define pwm_dutyL_hi(m)                pwmLeftHi.pulsewidth_ticks(  m );
#define pwm_dutyR_hi(m)                pwmRightHi.pulsewidth_ticks( m );
#define pwm_dutyL_low(m)               pwmLeftLow.pulsewidth_ticks( m );
#define pwm_dutyR_low(m)               pwmRightLow.pulsewidth_ticks( m );

// Use PWM3-1,PWM3-2 with TIM3
#define PWM_PORT_LEFT_HI    PB_5    // TIM3_CH2
#define PWM_PORT_RIGHT_HI   PB_4    // TIM3_CH1
// Use PWM3-3,PWM3-4 with TIM3
#define PWM_PORT_LEFT_LOW   PC_9    // TIM3_CH4
#define PWM_PORT_RIGHT_LOW  PC_8    // TIM3_CH3

/*
 * Timer and Interrupt definitions
 * */
#define periodTimerIntrStart()  __HAL_TIM_ENABLE_IT(  &TimHandle_pwm, TIM_IT_UPDATE )
#define periodTimerIntrStop()   __HAL_TIM_DISABLE_IT( &TimHandle_pwm, TIM_IT_UPDATE )
#define periodTimerIntrClear()  __HAL_TIM_CLEAR_FLAG( &TimHandle_pwm, TIM_FLAG_UPDATE)
#define pwmPeriodIntrEnable()    NVIC_EnableIRQ(  TIM_PWM_IRQ )
#define pwmPeriodIntrDisable()   NVIC_DisableIRQ( TIM_PWM_IRQ )

extern TPWM pwmLeftHi,pwmRightHi;
extern TPWM pwmLeftLow,pwmRightLow;
extern uint8_t gPcmShifNum;
void setPwmPeriod(int);
uint8_t calcPcmValidBits( void );

void pwm_period_timer_start();
void pwm_period_timer_stop();
void pwm_init() ;
#endif /* __PWM_LIB_H__ */


