#ifndef __SD_CARD_H__
#define __SD_CARD_H__

#include "sys.h"
#include "DirectSPI.h"

#if HAVE_DIRECT_SPI
    extern DirectSPI spi;
#   define spi_read()    spi.directWrite8(0xFF)
#   define spi_read16()  spi.directWrite16(0xFFFF)
#else
    extern SPI spi;
#   define spi_read()  spi.write(0xFF)
#endif

byte sd_data_byte();
void sd_init();
void sd_start_read(dword address);
void sd_stop_read();
void sd_read_pulse_byte(word  count1);

#endif

