#ifndef __SYS_H__
#define __SYS_H__

#include <stdint.h>
#include <stdbool.h>
#include "mbed.h"

/* Selectable options depended on each situation.
 * If a functionality is needed, the value should be set to 1.
 * */

/*----------------------
-- Selectable Options
----------------------*/
#define PWM16BIT                     1
#define DATA_8BIT_SUPPORT            1
#define HAVE_BUTTON_SW               1  // for 'Play','Pause','Power off'
/* Enable either the type of blink or dimmer  */
#define HAVE_LED_IND_PWM             1  // blink  LED during playing (750msec interval)
#define HAVE_LED_IND_BLINK           0  // dimmer LED during playing
/**********************/
#define HAVE_LED_PAUSE_INDICATOR     1  // blink or dimmer during pausing
#define HAVE_POWER_OFF_MODE          0  // under construction
//-- Select FAT32/FAT16 or FAT16 only
#define HAVE_FAT32                   1  // 0: FAT16 only, 1: FAT16 and FAT32 support
//--- end option setting

// TEST PORT
#define TEST_PORT               PA_8    // D7
// LED indicator
#define IND_LED                 PB_10

//-- debug purpose
#define UART_INFO                   1
#define DEBUG_WAV_PLAYER            0
#define DEBUG_FAT_LIB               0
#define DEBUG_SD_CARD               0
#define TEST_PORT_ENABLE            1
//
#define HAVE_DIRECT_SPI             1

typedef uint16_t word;
typedef uint32_t dword;
typedef uint8_t  byte;
typedef int8_t   sbyte;
typedef bool     sbit;

#ifdef __CC_ARM
#   define OPT_SPEED /* N/A */
#else
#   define OPT_SPEED __attribute__((optimize("O3")))
#endif

#endif /* __SYS_H__ */


