/*
#
# Copyright (C) 2010-2013, audin
# 2013/08: Modify for mbed for LPC1114FN28
# 2013/07: Modify for LPCOpen Platform.
# 2011/04, 2012/11
# 2010/11
# http://avr.paslog.jp
# This file is licensed under the MIT License.
#
*/

#include "mbed.h"
#include "led_tsk.h"
#include "Scheduler.h"

static int max_val	= 0;
static int val		= 0;
#define sio_get_led_blink_speed()	9 /* fixed preiod */

/* for CQ MyARM ,lpc1114fn28 */
DigitalOut led1(LED1);
DigitalOut led2(LED2);
#define led1_on()		led1=0	/*  Negative on */
#define led1_off()		led1=1
#define led2_on()		led2=1
#define led2_off()		led2=0

/*******************

* LED1 init

 *******************/
void led_init(void)
{
    led1_off();									/*  first off	*/
}

/*******************

* Fake PWM

 *******************/
static void pwm( int ms )
{
    led1_on();
    taskWait( ms );
    led1_off();
    taskWait( max_val - val);
}

/*******************

* LED task

 *******************/
void led_task( void)
{
    led_tsk( (void *)0 );	/* Just stub */
}

void led_tsk( void *pvParameters )
{
    ( void ) pvParameters;								// not used
    led_init();
    const int MIN_VAL	= 0;
    static int dir		= 1;
    while( 1 ) {
        if( ( val >= max_val) || ( val <= MIN_VAL) ) {
            max_val = sio_get_led_blink_speed() + 3 ;	// change period
            max_val <<= 1;								// adjust time
            if( val <= MIN_VAL ) {
                dir = 1;
                taskWait( 1000 );							// wait 1src if led off
            } else {
                dir = -1;
                val = max_val;
            }
        }
        val += dir;
        pwm( val );
    }
}

/*******************

* LED2 init

 *******************/
void led2_init(void)
{
    led2_off();									/*  first off	*/
}

void led2_task( void )
{
    led2_init();
    while( 1 ) {
        led2_on();
        taskWait(2000);
        led2_off();
        taskWait(2000);
    }
}

