/*
#
# Copyright (C) 2010-2014, audin
# 2014/02: Modify for mbed for CQ LPC11U35
# 2013/08: Modify for mbed for LPC1114FN28
# 2013/07: Modify for LPCOpen Platform.
# 2011/04, 2012/11
# 2010/11
# http://avr.paslog.jp
# This file is licensed under the MIT License.
#
*/

#include "mbed.h"
#include "led_tsk.h"
#include "Scheduler.h"


/* for CQ ,lpc11u35 */
DigitalOut led1(P0_20);
DigitalOut led2(P0_21);

#define led1_on()		led1=0	/*  Negative on */
#define led1_off()		led1=1
#define led2_on()		led2=0	/*  Negative on */
#define led2_off()		led2=1

/*******************

* Fake PWM class

 *******************/
static void pwm_elm( int ms, int max_ms, DigitalOut *led )
{
    *led=0; 			// negative on
    taskWait( ms );
    *led=1;
    taskWait( max_ms - ms);
}

class pwm_fake_t
{
    int max_val, val, MIN_VAL, dir, speed;
    DigitalOut *led;
public:
    pwm_fake_t(DigitalOut *_led, int _speed) {
        max_val = speed = _speed;
        val = MIN_VAL = 0;
        dir =1;
        led = _led;
    }
    void run() {
        if( ( val >= max_val) || ( val <= MIN_VAL) ) {
            max_val = speed;//sio_get_led_blink_speed() + 3 ;	// change period
            max_val <<= 1;								// adjust time
            if( val <= MIN_VAL ) {
                dir = 1;
                taskWait( 1000 );							// wait 1src if led off
            } else {
                dir = -1;
                val = max_val;
            }
        }
        val += dir;
        pwm_elm( val, max_val, led );
    }
};

/*******************

* LED1 task

 *******************/
void led1_task( void )
{
    led1_off();
    pwm_fake_t pwm_led( &led1, 10+3);
    while( 1 ) {
        pwm_led.run();
    }
}

/*******************

* LED2 task

 *******************/
void led2_task( void )
{
    led2_off();
    taskWait( 666 );
    pwm_fake_t pwm_led( &led2, 6+3);
    while( 1 ) {
        pwm_led.run();
    }
}

