####  mlib.py for mbed ####
# v0.9 # 2017/03 made by dinau
#
# Notice: Unsupported libraries.
#         These libraries must be specified in Makefile.
#   mbed-os
#   mbed-dev


# Usage:
# Download the dependency libraries from web.
#   $ make lib
# or
#   $ python mlib.py
# Specify URL of a particular library to get it.
#   $ python mlib.py http://...
# Checkout mbed library with specified revision number.
#   $ python mlib.py 136
#

import os,sys
import commands
from urlparse import urlparse

HG              = 1
GIT             = 2
MBEDOS          = 3
CMD_HG_CLONE    = 'hg clone -q '
CMD_GIT_CLONE   = 'git clone -q '
CMD_GIT_CHECKOUT= 'git checkout '

def hgClone(param):
    cmd = CMD_HG_CLONE + param
    return os.system( cmd )

def gitClone(param):
    cmd = CMD_GIT_CLONE + param
    return os.system( cmd )

def gitCheckout(param,disp=False):
    cmd = CMD_GIT_CHECKOUT + param
    if disp:
        print cmd
        sys.stdout.flush()
    return os.system( cmd )

def getDvcs(url):
    p = urlparse( url )
    #print p
    if ('developer.mbed.org' in url) or ('mbed.org' in url) or ('bitbucke.org' in url):
        return HG;
    elif 'mbed-os' in url:
        return MBEDOS
    elif 'github.com' in url:
        return GIT
    else:
        return 0

def getLibs(target_dir):
    savedir = os.getcwd()
    os.chdir(target_dir)
    liblist=[]
    for fname in os.listdir('.'):
        if os.path.isfile(fname):
            name, ext = os.path.splitext(fname)
            if ext == '.lib':
                if name != 'mbed-os':
                    liblist.append(fname)
    if len( liblist )  > 0:
        #print liblist
        for libfile in liblist:
            subdir, ext = os.path.splitext(libfile)
            if os.path.isdir( subdir ):
                print "%s :: already exists !" % (subdir)
                continue
            print subdir
            url = open(libfile).read()
            print url
            sys.stdout.flush()
            dvcs = getDvcs(url)
            if dvcs == HG:
                hgClone( url )
                getLibs(subdir)
            elif dvcs == MBEDOS:
                # Nothing is downloaded if mbed-os lib be.
                print 'mbed-os'
                sys.stdout.flush()
            elif dvcs == GIT:
                params = url.split('#')
                if len(params) == 1:
                    gitClone( params[0] )
                    getLibs(subdir)
                elif len(params) == 2:
                    gitClone( params[0] )
                    os.chdir(subdir)
                    print 'cd %s' % (subdir)
                    sys.stdout.flush()
                    gitCheckout( params[1] )
                    getLibs(subdir)
    os.chdir(savedir)

###################
# main program
###################
if len(sys.argv) == 1:
    print '--- Getting libraries ----'
    getLibs('.')
    print '--- end ---'
else:
    url = param1 = sys.argv[1]
    try:
        # Number or URL
        revNum = int(param1)
    except:
        # if URL of string
        # Down load mbed library from URL
        p = urlparse( url )
        if not("http" in p.scheme ) and not("https" in p.scheme ):
            print "URL error !"
        else:
            path = p.path
            if path[-1:] == '/':
                path = path[:-1]
            libdir  = os.path.basename(path)
            libname = libdir + '.lib'
            if not os.path.isdir( libdir ):
                with open( libname,'w') as fp:
                    fp.write( url )
                print '--- Getting libraries ----'
                getLibs('.')
                print '--- end ---'
    else:
        # if Number of string
        # get mbed library of specified revsion
        mbed_root_file ='mbed-root.txt'
        try:
            mbedRoot = open(mbed_root_file).read()
            os.chdir( mbedRoot.strip() )
            gitCheckout( 'mbed_lib_rev' + str( revNum ), True )
        except:
            print  "First, at least execute 'make' command !"




