/*
 * Copyright (C) 2012-2013 audin
 * This program is licensed under the Apache License, Version 2.0.
 * 2013/08: Modify for mbed for LPC1114FN28
 * Modified 2012/11: v02:
 *		Added external definition of stack size and task number. 
 * Modified 2012/10: v01:
 *		For working on Cortex-M0 and M3.
 *		Defined static tcb option for the cpu that has quite a less SRAM < 8kbyte.
 *
 * Original file is arduino-1.5\hardware\arduino\sam\libraries\Scheduler
 */

/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _SCHEDULDER_H_
#define _SCHEDULDER_H_

/* 
 * If you explicitly specify stack size, activate below,
 * or used "Default settings"
 */
//#define SCHEDULER_TASK_NUM_MAX 4 
//#define SCHEDULER_TASK_STACK_SIZE_EACH 200

/* 
 * Otherwise you can add compile option CFLAGS like this,  
  -DSCHEDULER_TASK_NUM_MAX=4
  -DSCHEDULER_TASK_STACK_SIZE_EACH=200
*/

/* Default settings */
/******************************************************************************************/
#ifndef SCHEDULER_TASK_NUM_MAX
#define COOP_TASK_NUM_MAX 4 /* Define max task number( include main loop ) */
#else
#define COOP_TASK_NUM_MAX (SCHEDULER_TASK_NUM_MAX)
#endif

#ifndef SCHEDULER_TASK_STACK_SIZE_EACH
#define MIN_STACK_SIZE (200) /* Minimum stack size per task, exclude main loop */
#else
#define MIN_STACK_SIZE (SCHEDULER_TASK_STACK_SIZE_EACH)
#endif
/* Thanks Ms.HI */
/******************************************************************************************/

#include <stdint.h>
#ifdef __cplusplus
extern "C" {
#endif
	typedef void (*SchedulerTask)(void);
	typedef void (*SchedulerParametricTask)(void *);

	void scheduler_init( void );
	void scheduler_startLoop( SchedulerTask task );
	void scheduler_start( SchedulerTask task );
#ifdef MBED_H
	void taskWait(uint32_t ms);
#else
	void wait(uint32_t ms);
#endif
	void yield();
#ifdef __cplusplus
}
#endif


#if __cplusplus
class SchedulerClass {
public:
	SchedulerClass();
	static void startLoop(SchedulerTask task, uint32_t stackSize = MIN_STACK_SIZE);
	static void start(SchedulerTask task, uint32_t stackSize = MIN_STACK_SIZE);
	static void start(SchedulerParametricTask task, void *data, uint32_t stackSize = MIN_STACK_SIZE);

#ifdef MBED_H
	static void taskWait(uint32_t ms);
#else
	static void wait(uint32_t ms) { ::wait(ms); };
#endif
	static void yield() { ::yield(); };
};

extern SchedulerClass Scheduler;

#endif

#endif	/* _SCHEDULDER_H_ */

