** SDFileSystemDMA ** is enhanced SDFileSystem library for STM32 micros by using DMA functionality.\\
Max read transfer rate reaches ** over 2MByte/sec ** at 24MHz SPI clock if enough read buffer size is set.\\
Even though minimum read buffer size (512Byte) is set, read transfer rate will reach ** over 1MByte/sec ** at 24MHz SPI Clock.\\
( but depends on the ability of each SD card)\\ 

Test program is here.\\
 [[https://developer.mbed.org/users/mimi3/code/SDFileSystemDMA-test/]]\\
 
{{/media/uploads/mimi3/sdfilesystemdma-speed-test3-read-buffer-512byte.png}}

{{/media/uploads/mimi3/sdfilesystemdma-speed-test-buffer-vs-spi-clock-nucleo-f411re-96mhz.png}}


Supported SPI port is shown below table.\\

** (v): Verified. It works well. ** \\
** (w): Probably it will work well. ** (not tested) \\
** (c): Only compiled. ** (not tested) \\
** (f): Over flash. ** \\
** (r): Only read mode. ** (when _FS_READONLY==1) \\
** (u) Under construction ** \\
** (z): Dose not work. ** \\


<<warning title="Caution">>
If your board has SRAM less than or equal to 8KB, the buffer size must be set to 512 Bytes.
<</warning>>


Supported Boards:\\
**Cortex-M0** 
|=Board |SRAM|=SPI1|=SPI2|=SPI3|
|NUCLEO-F030R8|**8KB**|**(v)**|||
|DISCO-F051R8 |**8KB**|(w) |||
| --NUCLEO-F031K6-- |4KB|(f)|||
| NUCLEO-F042K6|**6KB**|(r)|||
|NUCLEO-F070RB|16KB|(w)|||
|NUCLEO-F072RB|16KB|(w)|||
|NUCLEO-F091RC|32KB|(c)|||
**Cortex-L0** 
|=Board |SRAM|=SPI1|=SPI2|=SPI3|
|DISCO-L053C8 |**8KB**|(c)|||
|NUCLEO-L053R8|**8KB**|(c)|||
|NUCLEO-L073RZ|20KB|(c)|||
** Cortex-M3 **
|=Board|SRAM |=SPI1|=SPI2|=SPI3|
| DISCO-F100RB   |**8KB**|**(v)**|**(v)**|-|
| BLUEPILL-F103CB|20KB|(w)|(w)|-|
| NUCLEO-F103RB  |20KB|**(v)**|**(v)**|-|
| NUCLEO-L152RE  |80KB|**(v)**|(w)|-|
| MOTE-L152RC    |32KB|(w)|(w)|-|
** Cortex-M4 **\\
** F3 **
|=Board |SRAM|=SPI1|=SPI2|=SPI3|
| DISCO-F303VC |40KB|-|**(v)**|**(v)**|
| NUCLEO-F303RE|64KB|(w)|(w)|(w)|
| NUCLEO-F302R8|16KB|-|-|(c)|
| NUCLEO-F303K8|12KB|(c)|-|-|
| DISCO-F334C8 |12KB|(c)|-|-|
| NUCLEO-F334R8|12KB|(c)|-|-|
** F4 **
|=Board |=SPI1|=SPI2|=SPI3|
| ELMO-F411RE          |(w)|-|(w)|
| MTS-MDOT-F411RE      |(u)|-|(u)|
| MTS-DRAGONFLY-F411RE |(w)|-|(w)|
| NUCLEO-F411RE |**(v)**|-|**(v)**|
| NUCLEO-F401RE |(w)|-|(w)|
| MTS-MDOT-F405RG |(u)|-|(u)|
| NUCLEO-F410RB |(c)|-|(c)|
| NUCLEO-F446RE |(c)|-|(c)|
| NUCLEO-F429ZI |(c)|-|(c)|
| B96B-F446VE   |(c)|-|(c)|
| NUCLEO-F446ZE |(c)|-|(c)|
| DISCO-F429ZI  |(u)|-|(u)|
| DISCO-F469NI  |(c)|-|(c)|






<<info title="Information">>
This library is set to use "short file name" in SDFileSystemDMA/FATFileSystem/ChaN/ffconf.h . ( _USE_LFN=0) \\
You can change this option to  _USE_LFN=1 .
<</info>>





