
/* SD card Interface connection
 *           :  aitendo   :  General
 *  MCU sig. : IFB-254-SD :  PIN name
     ---     :    1       :   9 dat2
       CS    :    2       :   1 cs/dat3
      MOSI   :    3       :   2 di/cmd
       GND   :    4       :   3 vss1
       VCC   :    5       :   4 vdd
       CLK   :    6       :   5 clk
       GND   :    7       :   6 vss2
      MISO   :    8       :   7 do/dat0
       ---   :    9       :   8 dat1
       ---   :   10       :  11 wp
       ---   :   11       :  10 cd1
       ---   :   12       :  - case GND
*/

#define    SPI_DEV    1

#if defined(TARGET_STM32F4) || defined(TARGET_STM32L4)
#define CS          D10    /* PB_6 or etc. */
#if SPI_DEV==1
/* SPI1 */
#define MOSI        D11 /* PA_7 */
#define MISO        D12 /* PA_6 */
#define SCLK        D13 /* PA_5 */
#elif SPI_DEV==3
/* SPI3 */
#define MOSI        D4    /* PB_5 */
#define MISO        D5    /* PB_4 */
#define SCLK        D3    /* PB_3 */
#else 
#error
#endif
#endif

#if defined(TARGET_DISCO_F303VC)  \
 || defined(TARGET_NUCLEO_F303RE) \
 || defined(TARGET_NUCLEO_F302R8)
#define CS          PC_9
/* SPI3 */
#if SPI_DEV==3
#define MOSI        PC_12
#define MISO        PC_11
#define SCLK        PC_10
#elif SPI_DEV==2
/* SPI2 */
#define MOSI        PB_15
#define MISO        PB_14
#define SCLK        PB_13
#else 
#error
#endif
#endif

#if defined(TARGET_NUCLEO_F303K8) \
 || defined(TARGET_NUCLEO_F334R8) \
 || defined(TARGET_DISCO_F334C8)
#define CS          PA_1
/* SPI1 */
#if SPI_DEV==1
#define MOSI        PA_7
#define MISO        PA_6
#define SCLK        PA_5
#else 
#error
#endif
#endif

#if defined(TARGET_DISCO_F100RB)
#define CS          PB_12
/* SPI1 */
#if SPI_DEV==1
#define MOSI        PA_7
#define MISO        PA_6
#define SCLK        PA_5
#elif SPI_DEV==2
/* SPI2 */
#define MOSI        PB_15
#define MISO        PB_14
#define SCLK        PB_13
#else 
#error
#endif
#endif

#if defined(TARGET_NUCLEO_F103RB)
/* SPI1 */
#if SPI_DEV==1
#define CS          PB_8
#define MOSI        PA_7
#define MISO        PA_6
#define SCLK        PA_5
#elif SPI_DEV==2
/* SPI2 */
#define CS          PD_2
#define MOSI        PB_15
#define MISO        PB_14
#define SCLK        PB_13
#else
#error
#endif
#endif


#if defined(TARGET_STM32F0) \
 || defined(TARGET_STM32L1) \
 || defined(TARGET_STM32L0)
#define CS          D10		/* PB_6 */
#if 1
#define MOSI        D4		/* PB_5 */
#define MISO        D5		/* PB_4 */
#define SCLK        D3		/* PB_3 */
#else
#define MOSI        D11		/* PA_7 */
#define MISO        D12		/* PA_6 */
#define SCLK        D13		/* PA_5 */
#endif
#endif


