#include "mbed.h"
#include "FastPWM.h"


/* Period Interrupt monitor */
DigitalOut led(LED1);       

/* Using FastPWM library from:
 * http://developer.mbed.org/users/Sissors/code/FastPWM/
 * Thank you this library.
 */
#define TPWM FastPWM
TPWM pwm1(PA_8,1);
TPWM pwm2(PA_9,1);

/* PWM Timer constant value */
#define F_CLK_ABP1      (100*1000000)   // ABP1 TIM1 input clock is 100MHz
#define TIMER_INPUT_CLK  F_CLK_ABP1
#define MAX_PERIOD      ( TIMER_INPUT_CLK / (44100) )   // fs=44.1kHz 
#define MAX_DUTY        ( 2048 )        // Audio resolution : 11bit

/* Interrupt */ 
#define TIM_PWM      TIM1
#define TIM_PWM_IRQ  TIM1_UP_TIM10_IRQn

#define DELAY_MS        1

static TIM_HandleTypeDef TimHandle;

/* PWM Timer Interrupt routine */
void IntrPwmPeriod( void ){
    HAL_TIM_IRQHandler( &TimHandle );
}

/* HAL callback for PWM Timer Interrupt 
 * Test monitor 
 * */
void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim){
    led = 1;
    /* 1.3usec */
    led = 0;
}


int main() {

    TimHandle.Instance = TIM_PWM;

    int i =1, delta = 1;

    NVIC_SetVector( TIM_PWM_IRQ, (uint32_t)&IntrPwmPeriod );

    pwm1.period_ticks( MAX_PERIOD );
    pwm2.period_ticks( MAX_PERIOD );

    NVIC_EnableIRQ( TIM_PWM_IRQ );
    __HAL_TIM_ENABLE_IT( &TimHandle, TIM_IT_UPDATE );


    while(1) {
        pwm1.pulsewidth_ticks( i );
        pwm2.pulsewidth_ticks( i/2 );
        if( ( i >= MAX_DUTY ) || ( i <= 0 ) ){
            delta *= -1;
        }
        i += delta; 

        wait_ms( DELAY_MS );
    }
}
