#include "mbed.h"
#include "FastPWM.h"

/*  Those targets have been tested by this test program. 
 * DISCO_F051R8
 * DISCO_F100RB
 * DISCO_F303VC
 * DISCO_F407VG
 * NUCLEO_F030R8
 * NUCLEO_L152RE
 * NUCLEO_F411RE
 * 
 * with mbed library rev.113.
 */

/* Period Interrupt monitor */
DigitalOut led(LED1);       

/* Using FastPWM library from:
 * http://developer.mbed.org/users/Sissors/code/FastPWM/
 * Thank you this library.
 */
#define TPWM FastPWM

#if    defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F401RE) \
    || defined(TARGET_DISCO_F303VC)  || defined(TARGET_DISCO_F407VG)
    TPWM pwm_left( PA_8,1);
#if defined(TARGET_DISCO_F407VG)
    TPWM pwm_right(PA_10,1);
#else
    TPWM pwm_right(PA_9,1);
#endif
/* Interrupt */ 
#define TIM_PWM      TIM1
#if defined(TARGET_DISCO_F303VC)
    #define TIM_PWM_IRQ  TIM1_UP_TIM16_IRQn
#else
    #define TIM_PWM_IRQ  TIM1_UP_TIM10_IRQn
#endif
#elif  defined(TARGET_STM32F030R8) || defined(TARGET_STM32F051R8) \
    || defined(TARGET_STM32F100RB) || defined(TARGET_STM32L152RE) 
/*  PWM3-1          D12           PA_6       Audio out Left
    PWM3-2          D11           PA_7       Audio out Right */
    TPWM pwm_left( PA_6,1);
    TPWM pwm_right(PA_7,1);
/* Interrupt */ 
#define TIM_PWM      TIM3
#define TIM_PWM_IRQ  TIM3_IRQn
#endif

/* PWM Timer constant value */
#define F_CLK_ABP1      (SystemCoreClock)   // 
#define TIMER_INPUT_CLK  F_CLK_ABP1
#define MAX_PERIOD      ( TIMER_INPUT_CLK / (44100) )   // fs=44.1kHz 
#define MAX_DUTY        ( (int32_t)MAX_PERIOD )        // Audio resolution :
#define DELAY_MS        2

static TIM_HandleTypeDef TimHandle;

/* PWM Timer Interrupt routine */
void IntrPwmPeriod( void ){
    HAL_TIM_IRQHandler( &TimHandle );
}

/* HAL callback for PWM Timer Interrupt 
 * Test monitor 
 * */
void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim){
    (void)htim;
    led = 1;
    led = 0;
}

int main() {

    TimHandle.Instance = TIM_PWM;

    int i =1, delta = 1;

    NVIC_SetVector( TIM_PWM_IRQ, (uint32_t)&IntrPwmPeriod );

    pwm_left.period_ticks(  MAX_PERIOD );
    pwm_right.period_ticks( MAX_PERIOD );

    NVIC_EnableIRQ( TIM_PWM_IRQ );
    __HAL_TIM_ENABLE_IT( &TimHandle, TIM_IT_UPDATE );

    while(1) {
        pwm_left.pulsewidth_ticks( i );
        pwm_right.pulsewidth_ticks( i/2 );
        if( ( i > MAX_DUTY-1 ) || ( i <= 0 ) ){
            delta *= -1;
        }
        i += delta; 

        wait_ms( DELAY_MS );
    }
}



