#include "DirectSPI.h"

#if defined(SPI_SR_TXE) && defined(SPI_SR_RXNE)
#   define isTXE(spi)     (spi->SR & SPI_SR_TXE)
#   define isRXNE(spi)    (spi->SR & SPI_SR_RXNE)
#else
#   error Unsupported MCU at this moment !
#endif

#define SPIBUF8(spi)   *(__IO uint8_t  *)&spi->DR
#define SPIBUF16(spi)  spi->DR

#if DEVICE_SPI_ASYNCH
    #define SPI_S(obj)    (( struct spi_s *)(obj))
    //#define SPI_S(obj)    (( struct spi_s *)(&(obj->spi)))
#else
    #define SPI_S(obj)    (( struct spi_s *)(obj))
#endif

DirectSPI::DirectSPI(PinName mosi, PinName miso, PinName sclk) : SPI(mosi, miso, sclk) {
    spi = spi_get_id(mosi, miso, sclk, NC);
#if TODO
    spiSend = is16bit ? &DirectSPI::spiSend16 : &DirectSPI::spiSend8;
#endif
}

uint16_t DirectSPI::directWrite(uint16_t data) {
    if(_bits == 16){
        while(!isTXE(spi));
        SPIBUF16(spi) = data;
        while(!isRXNE(spi));
        return SPIBUF16(spi);
    } else {
        while(!isTXE(spi));
        SPIBUF8(spi) = data;
        while(!isRXNE(spi));
        return SPIBUF8(spi);
    }
}

uint16_t DirectSPI::directWrite8(uint16_t data) {
    while(!isTXE(spi));
    SPIBUF8(spi) = data;
    while(!isRXNE(spi));
    return SPIBUF8(spi);
}

uint16_t DirectSPI::directWrite16(uint16_t data) {
    while(!isTXE(spi));
    SPIBUF16(spi) = data;
    while(!isRXNE(spi));
    return SPIBUF16(spi);
}

SPI_TypeDef *DirectSPI::spi_get_id( PinName mosi, PinName miso, PinName sclk, PinName ssel) {
    // Determine the SPI to use
    SPIName spi_mosi = (SPIName)pinmap_peripheral(mosi, PinMap_SPI_MOSI);
    SPIName spi_miso = (SPIName)pinmap_peripheral(miso, PinMap_SPI_MISO);
    SPIName spi_sclk = (SPIName)pinmap_peripheral(sclk, PinMap_SPI_SCLK);
    SPIName spi_ssel = (SPIName)pinmap_peripheral(ssel, PinMap_SPI_SSEL);

    SPIName spi_data = (SPIName)pinmap_merge(spi_mosi, spi_miso);
    SPIName spi_cntl = (SPIName)pinmap_merge(spi_sclk, spi_ssel);

    return (SPI_TypeDef *) ( (SPIName)pinmap_merge(spi_data, spi_cntl) );
}
