#ifndef __DIRECTSPI_H_
#define __DIRECTSPI_H_

#include "mbed.h"
#include "PeripheralPins.h"
#define TODO    0

class DirectSPI : public SPI
{
public:
    DirectSPI(PinName mosi, PinName miso, PinName sclk);
    uint16_t directWrite8(uint16_t data);
    uint16_t directWrite16(uint16_t data);
    uint16_t directWrite(uint16_t data);
    SPI_TypeDef *spi_get_id( PinName mosi, PinName miso, PinName sclk, PinName ssel);
    void operator = (uint8_t d8){
        volatile uint16_t res;
        res = directWrite8( d8 );
    }
protected:
    SPI_TypeDef *spi;
#if TODO
    uint16_t (DirectSPI::*spiSend)(uint16_t data);
    uint16_t spiSend8(uint16_t data){return 0;};
    uint16_t spiSend16(uint16_t data){return 0;};
#endif
};

#endif /* __DIRECTSPI_H_ */

