####  lib.py for mbed ####
# v0.5
# 2017/02 made by dinau
#
# Notice: Unsupported libraries.
#         These libraries must be specified in Makefile.
#   mbed-os
#   mbed-dev


# Usage:
#   $ make lib
# or
#   $ python makelib.py
#
import os,sys
import commands
from urlparse import urlparse
HG              = 1
GIT             = 2
MBEDOS          = 3
CMD_HG_CLONE    = 'hg clone -q '
CMD_GIT_CLONE   = 'git clone -q '
CMD_GIT_CHECKOUT= 'git checkout -q '

def hgClone(param):
    cmd = CMD_HG_CLONE + param
    return os.system( cmd )

def gitClone(param):
    cmd = CMD_GIT_CLONE + param
    return os.system( cmd )

def gitCheckout(param):
    cmd = CMD_GIT_CHECKOUT + param
    return os.system( cmd )

def getDvcs(url):
    if ('developer.mbed.org' in url) or ('mbed.org' in url) or ('bitbucke.org' in url):
        return HG;
    elif 'mbed-os' in url:
        return MBEDOS
    elif 'github.com' in url:
        return GIT
    else:
        return 0

def getLibs(target_dir):
    savedir = os.getcwd()
    os.chdir(target_dir)
    liblist=[]
    for fname in os.listdir('.'):
        if os.path.isfile(fname):
            name, ext = os.path.splitext(fname)
            if ext == '.lib':
                if name != 'mbed-os':
                    liblist.append(fname)
    if len( liblist )  > 0:
        #print liblist
        for libfile in liblist:
            subdir, ext = os.path.splitext(libfile)
            print subdir
            url = open(libfile).read()
            print url
            sys.stdout.flush()
            dvcs = getDvcs(url)
            if dvcs == HG:
                hgClone( url )
                getLibs(subdir)
            elif dvcs == MBEDOS:
                # Nothing is downloaded if mbed-os lib be.
                print 'mbed-os'
                sys.stdout.flush()
            elif dvcs == GIT:
                params = url.split('#')
                if len(params) == 1:
                    gitClone( params[0] )
                    getLibs(subdir)
                elif len(params) == 2:
                    gitClone( params[0] )
                    os.chdir(subdir)
                    print 'cd %s' % (subdir)
                    sys.stdout.flush()
                    gitCheckout( params[1] )
                    getLibs(subdir)
    os.chdir(savedir)
###################
# main prog
###################
if len(sys.argv) >= 2:
    url = sys.argv[1]
    dvcs = getDvcs( url )
    if dvcs == HG:
        p = urlparse( url )
        path = p.path
        if path[-1:] == '/':
            path = path[:-1]
        libdir = os.path.basename(path)
        hgClone( url )
        getLibs(libdir)
    elif dvcs == GIT:
        params = url.split('#')
        if len(params) == 1:
            gitClone( params[0] )
        elif len(params) == 2:
            gitClone( params[0] )
            os.chdir(subdir)
            print 'cd %s' % (subdir)
            sys.stdout.flush()
            gitCheckout( params[1] )
else:
    print '--- Getting libraries ----'
    getLibs('.')
    print '--- end ---'
