#include "mbed.h"
#include "DirectSPI.h"


/* SPI1 */
#define MOSI      SPI_MOSI  /* D11  PA_7 */
#define MISO      SPI_MISO  /* D12  PA_6 */
#define SCLK      SPI_SCK   /* D13  PA_5 */
#define CS        SPI_CS    /* D10  PB_6 */

DirectSPI spi(MOSI, MISO, SCLK); // mosi, miso, sclk
DigitalOut cs(CS);

/* auto width transfer test */
void test_auto() {
    spi.format(8,3);
    while(1){
        cs = 1;
        spi.directWrite(0xaa);
        spi.directWrite(0xaa);
        cs = 0;
    }
}

/* 8bit width transfer test */
void test_bit8() {
    spi.format(8,3);
    while(1){
        cs = 1;
        spi.directWrite8(0xaa);
        spi.directWrite8(0xaa);
        cs = 0;
    }
}

/* 16bit width transfer test */
void test_bit16() {
    spi.format(16,3);
    while(1){
        cs = 1;
        spi.directWrite16(0x5503);
        spi.directWrite16(0x5503);
        cs = 0;
    }
}

/* 8bit width transfer test using standard library*/
void test_std8() {
    spi.format(8,3);
    while(1){
        cs = 1;
        spi.write(0xaa);
        spi.write(0xaa);
        cs = 0;
    }
}

int main(){
    spi.frequency(24 * 1000000);

    /* Select the one of the test function */
    //test_auto();
    test_bit8();
    //test_bit16();
    //test_std8();
}


