#include "mbed.h"
#include "Servo.h"
 
Servo s1(PB_3); //pin 3 - mg995
Servo s2(PB_4); // pin 5 - mg995
Servo s3(PB_10); // pin 6 - mg995
Servo s4(PC_7); // pin 9 - mg995
Servo s5(PB_6); // pin 10 - mg996r
Servo s6(PA_7); // pin 11 - mg996r
Serial pc(USBTX, USBRX);
 
int main() {
    printf("Servo Calibration Controls:\n");
    printf("1,2,3 - Position Servo (full left, middle, full right)\n");
    printf("4,5 - Decrease or Increase range\n");
 
    double range = 0.0005;
    double position = 0.5;
    
    while(1) {                   
        switch(pc.getc()) {
            case '1': position = 0.1; break;
            case '2': position = 0.2; break;
            case '3': position = 0.3; break;
            case '4': position = 0.4; break;
            case '5': position = 0.5; break;
            case '6': position = 0.6; break;
            case '7': position = 0.7; break;         
            case '8': position = 0.8; break;
            case '9': position = 0.9; break;
            case '0': position = 1.0; break;
        }
        printf("position = %.1f, range = +/-%0.4f\n", position, range);
        /*s1.calibrate(range, 180.0);
        s2.calibrate(range, 180.0);
        s3.calibrate(range, 180.0);
        s4.calibrate(range, 180.0);
        s5.calibrate(range, 180.0);
        s6.calibrate(range, 180.0);*/
        s1 = position;
        s2 = position;
        s3 = position;
        s4 = position;
        s5 = position;
        s6 = position;      
    }
}