// Da bi upisali program na Nucleo plocu, dovoljno je povezati je, nakon instalacije driver-a trebalo bi da se pojavi kao eksterni storage. Pritisak na crno dugme na ploci resetuje na pocetno stanje plocu, tako da kompajliranjem i kopiranjem fajla na plocu se prebacuje program
// plave i crvene zice na proto bordu - vcc
// crne i bijele zice na proto bordu - gnd
// TowerPro MG995 Data Sheet - http://www.electronicoscaldas.com/datasheet/MG995_Tower-Pro.pdf || https://www.scribd.com/doc/87240823/TowerPro-Datasheet
#include "mbed.h" //standardna mbed-arm biblioteka
#include "Servo.h" //servo biblioteka

Servo s1(PB_3); //pin 3 - mg995
Servo s2(PB_4); // pin 5 - mg995
Servo s3(PB_10); // pin 6 - mg995
Servo s4(PC_7); // pin 9 - mg995
Servo s5(PB_6); // pin 10 - mg996r
Servo s6(PA_7); // pin 11 - mg996r
Serial pc(USBTX, USBRX); // serial komunikacija preko usb-a

bool veci (float one,float  two,float  three,float  four,float  five,float  six)  // provjera vrijednosti unosa - prihvata se 0-100 sa korakom od 1 ili 0.000 do 1.000 sa korakom od 0.001
{
// razmotriti vecu rezoluciju od 1/100 nakon testiranja (360/100=3.6 sto mozda nece biti dovoljno) - u slucaju 0.000-1.000 je 1/1000 -> .36 stepeni korak
// testirati najmanji step na mg995 i mg995s && omoguciti kalibraciju
    if(one > 1) {
        if(one > 100) {
            return false;
        } else {
            one/=100;
            return true;
        }
    } else if(two > 1) {
        if(two > 100) {
            return false;
        } else {
            two/=100;
            return true;
        }
    } else if(three > 1) {
        if(three > 100) {
            return false;
        } else {
            three/=100;
            return true;
        }
    } else if(four > 1) {
        if(four > 100) {
            return false;
        } else {
            four/=100;
            return true;
        }
    } else if(five > 1) {
        if(five > 100) {
            return false;
        } else {
            five/=100;
            return true;
        }
    } else if(six > 1) {
        if(six > 100) {
            return false;
        } else {
            six/=100;
            return true;
        }
    } else {
        return true;
    }
}

void kalibracijaSingle(int servoN, float pozicija) // koristi se za kalibraciju samo jednog motora
{
    // printf potreban samo za testiranje - kasnije softverom dodati dugmice za kalibraciju
    printf("Kontrole za kalibraciju servo motora:\n");
    printf("1,2 - Povecavanje i smanjivanje opsega\n");
    printf("3 - Izlaz iz kalibracije\n");

    double range = 0.0005;
    bool kalibracija = true;

    while(kalibracija) { // dok je kalibracija true, povecavaj i smanjuj range, tj citaj svaki upis.
        switch(pc.getc()) {
            case '1':
                range += 0.0001;
                break;
            case '2':
                range -= 0.0001;
                break;
            case '3': // input za izlaz iz kalibracije
                kalibracija = false;
        }
        if(!kalibracija) { // izlaz
            return;
        }
        printf("pozicija = %.1f, range = +/-%0.4f\n", pozicija, range); // ispis trenutnog stanja motora
        if(servoN == 1) {
            s1.calibrate(range, 180.00); // upis stanja na motore
            s1 = pozicija;
        } else if(servoN == 2) {
            s2.calibrate(range, 180.00);
            s2 = pozicija;
        } else if(servoN == 3) {
            s3.calibrate(range, 180.00);
            s3 = pozicija;
        } else if(servoN == 4) {
            s4.calibrate(range, 180.00);
            s4 = pozicija;
        } else if(servoN == 5) {
            s5.calibrate(range, 180.00);
            s5 = pozicija;
        } else if(servoN == 6) {
            s6.calibrate(range, 180.00);
            s6 = pozicija;
        }
    }
}


int main()
{
    pc.baud(9600); // podesavanje baud rate-a na usb-u
    //pc.format(8, Serial::None, 1);
    printf("Servo test aplikacija\n");
    float one, two , three, four, five, six;; // pozicija
    int kalibracija; // mod za kalibraciju
    printf("Spremna za unos.\n");

    while(1) { // loop
        if(pc.scanf("%3.3f%3.3f%3.3f%3.3f%3.3f%3.3f%d", &one, &two, &three, &four, &five, &six, &kalibracija)) { // za vise servo motora se upisuje u promenjive redom // dodati data var prije inputa u slucaju da ne radi
            //pc.scanf("%3f", &position);
            // int na kraju koji se prosledjuje uvijek treba da bude 0 sem kada zeli da se pristupi modu za kalibraciju
            if(kalibracija == 1) {
                printf("Mod za kalibraciju! Unesite broj motora (pin 3-1, pin 5-2, pin 6-3, pin 9-4, pin 10-5, pin 10-6)\n");
                int i;
                scanf("%d", &i);
                if(i == 1) {
                    kalibracijaSingle (i, one);
                } else if(i == 2) {
                    kalibracijaSingle (i, two);
                } else if(i == 3) {
                    kalibracijaSingle (i, three);
                } else if(i == 4) {
                    kalibracijaSingle (i, four);
                } else if(i == 5) {
                    kalibracijaSingle (i, five);
                } else if(i == 6) {
                    kalibracijaSingle (i, six);
                } else {
                    printf("Greska, ne postoji takav motor, motori ce biti podeseni na unesene vrijednosti.\n");   // hvatanje greske
                }
            }

            if ( veci (one, two, three, four, five, six)) { // && verify(one, two, three, four, five, six)  // moze i softverski
                printf("Pozicija #1 = %3.3f ,", one);
                printf("Pozicija #2 = %3.3f ,", two);
                printf("Pozicija #3 = %3.3f ,", three);
                printf("Pozicija #4 = %3.3f ,", four);
                printf("Pozicija #5 = %3.3f ,", five);
                printf("Pozicija #6 = %3.3f .\n", six);
                //servo motor = pozicija; // upis pozicije na motore
                s1 = one;
                s2 = two;
                s3 = three;
                s4 = four;
                s5 = five;
                s6 = six;
                printf("Spreman za sledeci unos."); // obavestenje da je program spreman za sledeci upis (prvi karakter ce biti identifikator za softver e.g. "|" )
            } else {
                printf("Greska - unos veci od 100, vrijednost proslijedjena motoru ne moze biti veca od 100(%)"); // prijava greske (identifikator e.g. "^")
            }
            // vidjeti druge vidove komunikacije sem direktne serial-usb || provjeriti povezivanje nucleo ploce sa Espressif esp8266
        }
    }
}

//bool verify(){} // implement check if number - koristice se softver tako da nije potrebno raditi verifikaciju unosa - moze AT komande preko UART-a