#include "mbed.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "lpc_swim_font.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

int main()
{
  DMBoard::BoardError err;
  DMBoard* board = &DMBoard::instance();
  RtosLog* log = board->logger();
  Display* disp = board->display();
  
    //Turn all LEDs off
    myled1 = 1;  //LED1 is active low, turn it off
    myled2 = 1;  //LED2 is active low, turn it off
    myled3 = 0;  //LED3 is active high, turn it off
    myled4 = 0;  //LED4 is active high, turn it off
  
  do {
    err = board->init();
    if (err != DMBoard::Ok) {
      log->printf("Failed to initialize the board, got error %d\r\n", err);
      break;
    }
    
    log->printf("\n\nHello World!\n\n");
    
    SWIM_WINDOW_T win;
    void* fb = disp->allocateFramebuffer();
    if (fb == NULL) {
      log->printf("Failed to allocate memory for a frame buffer\r\n");
      err = DMBoard::MemoryError;
      break;
    }
    
    // Prepare fullscreen
    swim_window_open(&win, 
                     disp->width(), disp->height(),         // full size
                     (COLOR_T*)fb,
                     0,0,disp->width()-1, disp->height()-1, // window position and size
                     1,                                     // border
                     WHITE, BLUE, BLACK);                   // colors: pen, backgr, forgr
    swim_set_title(&win, "My Program", BLACK);
  
    // Message
    swim_put_text_xy(&win, "Hello World!", 100, 100);
    
    // Start display in default mode (16-bit)
    Display::DisplayError disperr = disp->powerUp(fb);
    if (disperr != Display::DisplayError_Ok) {
      log->printf("Failed to initialize the display, got error %d\r\n", disperr);
      break;
    }
  } while(false);

  if (err != DMBoard::Ok) {
    log->printf("\nTERMINATING\n");
    wait_ms(2000); // allow RtosLog to flush messages
    mbed_die();
  }  

  while(true) 
  {
        myled3 = 0;  //Turn LED3 off
        myled1 = 0;  //Turn LED1 on
        wait(0.2);   //Wait 200 ms
        myled1 = 1;  //Turn LED1 off
        myled2 = 0;  //Turn LED2 on
        wait(0.2);   //Wait 200 ms
        myled2 = 1;  //Turn LED2 off
        myled4 = 1;  //Turn LED4 on
        wait(0.2);   //Wait 200 ms
        myled4 = 0;  //Turn LED4 off
        myled3 = 1;  //Turn LED3 on
        wait(0.2);   //Wait 200 ms
  }   
}
