


#ifndef OBSERVER_H
#define OBSERVER_H

#include "Node.h"
#include "DistanceFrame.h"
#include "debug.h"
#include "BufferedOutput.h"
#include "MavlinkPassthrough.h"

#define HEADERCODE 253

class Observer : public Node
{
    public:
        
        // Constructor
        Observer( MM2WayRanging& newRanging, DW1000& newDw, Serial& output, Serial& mavlinkIn ) ;
        
        // Executes the observers's functionality at each timestep
        virtual void execute() ;
        
        // The callback which implements the observer functionality
        void observerCallbackRX() ;
        void observerCallbackTX() ;
        
    private:
    
        // Buffered output for sending data frames
        BufferedOutput bufferedOutput ;
        
        // Mavlink passthrough object
        MavlinkPassthrough mavlinkPassthrough ;
    
} ;

#endif