
#ifndef MAVLINKPASSTHROUGH_H
#define MAVLINKPASSTHROUGH_H

// Dependancies
#include "mbed.h"
#include "debug.h"
#include "BufferedOutput.h"

// MAVlink defines
#define MAVLINKSTARTCHAR 254
#define MAVLINKADDITIONALDATA 6

// Circular buffer for mavlink characters
const int mavlinkBufferSize = 255 ;

// Enumeration possible mavlink frame states
enum mavlinkTransferStateType { START, LENGTH, DATA, TRANSFER } ;

class MavlinkPassthrough
{
    public:
    
        // Constructor
        MavlinkPassthrough( Serial& serial, BufferedOutput& bufferedOutput ) ;
        
        // Contains the MAVlink passthrough background tasks
        void executeBackgroundTask() ;

    protected:
    
        // Serial object for receiving mavlink
        Serial& mavlinkIn ;
        
        // Buffered output for outgoing frames
        BufferedOutput& bufferedOutput ;
        
        // MAVlink Receive Callback
        void mavlinkInCallback() ;
        
        // Maintains the mavlink buffer, transfering frames out as they arrive
        void maintainMavlinkBuffer() ;
        
        // The state of the current MAVlink frame 
        mavlinkTransferStateType mavlinkTransferState ;
        // The remaining characters to be received in the current mavlink frame
        char currentMavlinkFrameLength ;
        
        // Buffer which hold mavlink characters received via the serial connection
        char mavlinkBuffer[ mavlinkBufferSize + 1 ] ;
        // Pointers to entry and exit points to the buffer
        volatile char mavlinkBufferIn ;
        volatile char mavlinkBufferOut ;
        volatile char mavlinkBufferRead ;

} ;


#endif