
#ifndef BUFFEREDOUTPUT_H
#define BUFFEREDOUTPUT_H

// Dependancies
#include "mbed.h"
#include "debug.h"

// Circular buffer for mavlink characters
const int framesBufferSize = 255;

class BufferedOutput
{
    public:
    
        // Constructor
        BufferedOutput( Serial& serial ) ;
        
        // Contains the MAVlink passthrough background tasks
        void executeBackgroundTask() ;
        
        // Adding a frame to the output buffer
        //void addFrame( char* frame, char length ) ;
        
        // Adding a character to the output buffer
        void addChar( char c ) ;

    protected:
    
        // Serial object where outward frames are written
        Serial& framesOut ;
        
        // Frames Send Callback
        void framesOutCallback() ;
        
        // Buffer which hold mavlink characters received via the serial connection
        char framesBuffer[ framesBufferSize + 1 ] ;
        // Pointers to entry and exit points to the buffer
        volatile char framesBufferIn  ;
        volatile char framesBufferOut  ;
        
        // Indicates if a frame is currently being transfered over serial
        bool frameTransferInProgress ;
    
} ;


#endif