#include "BufferedOutput.h"

BufferedOutput::BufferedOutput( Serial& serial ) : framesOut( serial )
{
    // Debug startup message
    debugprintf("Initializing Buffered Output object\r\n") ;
    
    // Attaching the serial interrupt callbacks
    framesOut.attach(this, &BufferedOutput::framesOutCallback, Serial::TxIrq ) ;
    
    // Initializing the buffer pointers
    framesBufferIn = 0 ;
    framesBufferOut = 0 ;
    
    // Initializing frame transfer state
    frameTransferInProgress = false ;

}

void BufferedOutput::executeBackgroundTask()
{
    // Checking if the Frame buffer is non empty
    if( !(framesBufferOut == framesBufferIn) && !frameTransferInProgress )
    {
        //debugprintf("Starting frames Tx\r\n") ;
        // Moving characters from the mavlink buffer to the USART device buffer
        // while there are still chars in the MAVLink Buffer
        if( framesOut.writeable() )
        {
            // Disabling interrupts while interacting with UART device
            __disable_irq();
            // Putting character to the USART device buffer
            framesOut.putc( framesBuffer[ framesBufferOut ] ) ;
            // Disabling interrupts while modifying buffers
            __enable_irq();
            // Incrementing the output pointer
            framesBufferOut = ( framesBufferOut + 1 ) % framesBufferSize ;
            // Indicating that the frame transfer has started
            frameTransferInProgress = true ;
        }
    }
}

/*
void BufferedOutput::addFrame( char* frame, char length )
{
    // Disabling interrupt while modifying global buffers
    __disable_irq() ;
    // Looping over all characters in the frame
    for( char index = 0 ; index < length ; index++ )
    {
        // Placing char output buffer
        framesBuffer[ framesBufferIn ] = frame[index] ;
        // Incrementing the input pointer
        framesBufferIn = ( framesBufferIn + 1 ) % framesBufferSize ;
    }
    // Re-enabling interrupts
    __enable_irq() ;
}
*/

void BufferedOutput::addChar( char c )
{
    // Placing char output buffer
    framesBuffer[ framesBufferIn ] = c ;
    // Incrementing the input pointer
    framesBufferIn = ( framesBufferIn + 1 ) % framesBufferSize ;
}

void BufferedOutput::framesOutCallback()
{
    // Moving characters from the mavlink buffer to the USART device buffer
    // while there are still chars in the MAVLink Buffer
    while( framesOut.writeable() && !( framesBufferOut == framesBufferIn ) )
    {
        // Putting character to the USART device buffer
        framesOut.putc( framesBuffer[ framesBufferOut ] ) ;
        // Incrementing the output pointer
        framesBufferOut = ( framesBufferOut + 1 ) % framesBufferSize ;
    }
    // If buffer emptied indicate that tx interrupts are over
    if( ( framesBufferOut == framesBufferIn ) )
    {
        frameTransferInProgress = false ;
    }
}