
#include "mbed.h"
#include "MM2WayRanging.h"
#include "DW1000.h"
#include "debug.h"


#ifndef NODE_H
#define NODE_H


enum NodeType { ANCHOR, BEACON, OBSERVER } ;

class Node
{
    public:
    
        // Constructor
        Node( MM2WayRanging& newRanging, DW1000& newDw ) ;
        
        // Executes the node's functionality at each timestep
        virtual void execute() ;
        
        // Sets the address of the node
        void setAddress( uint8_t address ) ;

    protected:
        
        // Ranging object for ranging
        MM2WayRanging& ranging ;
        
        // Decawave object for direct interaction with the device
        DW1000& dw ;

} ;


#endif
