#include "SDcardM.h"
#include "SDBlockDevice.h"
#include "mbed.h"

extern SDBlockDevice sd;
extern Serial pc;

char writeBuffer[520];
char readBuffer[512];
int i;
bd_addr_t block;
bd_addr_t* bp=(bd_addr_t*) readBuffer;

bool SD_init()
{
    for (int j=0; j<520; j++) writeBuffer[j]=0;
    i = 0;
    sd.deinit();
    if(sd.init()) {
        return false;
    }
    sd.frequency(24000000);
    sd.read(readBuffer, 0, 512);
    block=*bp;
    pc.printf("CURRENT BLOCK: %d\r\n", block);
    return true;
}

void SD_log_char(char c)
{
    writeBuffer[i]=c;
    i++;
    if(i==512) {
        sd.program(writeBuffer, block, 512);
        block+=512;;
        *bp=block;
        sd.program(readBuffer, 0, 512);
        i=0;
    }
}

void SD_log_string(const char* s)
{
    while(*s) {
        SD_log_char(*s);
        s++;
    }
}

void SD_log_float(float f)
{
    memcpy(writeBuffer+i, (char*) (&f), 4);
    i+=4;
    if(i>=512) {
        sd.program(writeBuffer, block, 512);
        block+=512;
        sd.program(readBuffer, 0, 512);

        for(int j=0; j+512<i; j++) {
            writeBuffer[j]=writeBuffer[j+512];
        }
        i-=512;
    }
}

void SD_log_int(int f)
{
    memcpy(writeBuffer+i, (char*) (&f), 4);
    i+=4;
    if(i>=512) {
        sd.program(writeBuffer, block, 512);
        block+=512;
        sd.program(readBuffer, 0, 512);

        for(int j=0; j+512<i; j++) {
            writeBuffer[j]=writeBuffer[j+512];
        }
        i-=512;
    }
}


void SD_flush()
{
    sd.program(writeBuffer, block, 512);
    block+=512;
    *bp=block;
    sd.program(readBuffer, 0, 512);
    i=0;
}