#ifndef MBED_GPSM_H
#define MBED_GPSM_H

#include "mbed.h"
#include <string>

#define NOT_READY   0
#define NO_LOCK     1
#define GOOD        2

#define PI (3.141592653589793)

/**  A GPS interface for reading from a ublox LEA-6S GPS Module */
class GPSM {
public:

    static Serial* _gps;
    static void rx_interrupt();

    /** Create the GPS interface, connected to the specified serial port
     */    
    
    static void GPSM_Init(PinName tx, PinName rx);
    
    /** Sample the incoming GPS data, returning whether there is a lock
     * 
     * @return 1 if there was a lock when the sample was taken (and therefore .longitude and .latitude are valid), else 0
     */
    static int poll();
    static float get_nmea_longitude();
    static float get_nmea_latitude();
    static float get_dec_longitude();
    static float get_dec_latitude();
    static float get_msl_altitude();
    static float get_course_t();
    static float get_speed_km();
    static int get_satelites();
    static float get_altitude_ft();
    
private:
    GPSM(){} //Unconstructable library class

    static float nmea_to_dec(float, char);
    static float trunc(float v);
    static void format_for_log(void);
    static void init_GPS();
    
    
    
    static int  msg_ind;
    static char msg[128];
    static char bfr[1030];
    static bool is_logging;
    static bool ready;
    
    // calculated values
    static float dec_longitude;
    static float dec_latitude;
    static float altitude_ft;
    
    // GGA - Global Positioning System Fixed Data
    static float nmea_longitude;
    static float nmea_latitude;    
    static float utc_time;
    static char ns, ew;
    static int lock;
            
    // RMC - Recommended Minimmum Specific GNS Data
    static char rmc_status;
    static float speed_km;
    static float course_d;
    static int date;
    
};
#endif
