#include "GPSM.h"
int     GPSM::lock           =     0;
int     GPSM::date           =     0;
int     GPSM::msg_ind        =    -1;
float   GPSM::dec_latitude   =   0.0;
float   GPSM::dec_longitude  =   0.0;
float   GPSM::nmea_latitude  =   0.0;
float   GPSM::nmea_longitude =   0.0;
float   GPSM::speed_km       =   0.0;
float   GPSM::course_d       =   0.0;
float   GPSM::utc_time       =   0.0;
char    GPSM::msg[128]       =    {};
char    GPSM::bfr[1030]      =    {};
char    GPSM::rmc_status     =   'V';
char    GPSM::ns             =   ' ';
char    GPSM::ew             =   ' ';
Serial* GPSM::_gps           =     0;
bool    GPSM::ready          = false;

void GPSM::GPSM_Init(PinName tx, PinName rx)
{

    _gps=new Serial(tx, rx, 9600);

    nmea_longitude = 0.0;
    nmea_latitude = 0.0;
    utc_time = 0;
    ns = ' ';
    ew = ' ';
    lock = 0;

    rmc_status = 'V';
    speed_km = 0.0;
    course_d = 0.0;
    date = 0;

    dec_longitude = 0.0;
    dec_latitude = 0.0;

    extern Serial pc;
    
    init_GPS();
    
    wait(1.0);

}


float GPSM::nmea_to_dec(float deg_coord, char nsew)
{
    int degree = (int)(deg_coord/100);
    float minutes = deg_coord - degree*100;
    float dec_deg = minutes / 60;
    float decimal = degree + dec_deg;
    if (nsew == 'S' || nsew == 'W') { // return negative
        decimal *= -1;
    }
    return decimal;
}


int GPSM::poll()
{
    if (!ready) return NOT_READY;
    ready=false;
    if (lock) return GOOD;
    else return NO_LOCK;
}


// INTERNAL FUNCTINS ////////////////////////////////////////////////////////////
void GPSM::rx_interrupt()
{
    extern Serial pc;
    if(msg_ind < 0) {
        if(_gps->getc() == '$') msg_ind = 0;
        return;
    }
    msg[msg_ind] = _gps->getc();
    if (msg[msg_ind] == '\r' || msg_ind==90) {
        msg[msg_ind] = 0;
        if (sscanf(msg, "GPRMC,%f,%c,%f,%c,%f,%c,%f,%f,%d", &utc_time, &rmc_status, &nmea_latitude, &ns, &nmea_longitude, &ew, &speed_km, &course_d, &date) >= 2) {
            if(rmc_status == 'V') lock=0;
            if(rmc_status == 'A') lock=1;
            speed_km*=1.852;
            dec_latitude = nmea_to_dec(nmea_latitude, ns);
            dec_longitude = nmea_to_dec(nmea_longitude, ew);
            ready=true;
        }
        msg_ind=-1;
        return;
    }
    msg_ind++;
}

void GPSM::init_GPS()
{
//GGA OFF
    _gps->putc(0xB5);
    _gps->putc(0x62);
    _gps->putc(0x06);
    _gps->putc(0x01);
    _gps->putc(0x08);
    _gps->putc(0x00);
    _gps->putc(0xF0);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x01);
    _gps->putc(0x00);
    _gps->putc(0x24);
//GLL OFF
    _gps->putc(0xB5);
    _gps->putc(0x62);
    _gps->putc(0x06);
    _gps->putc(0x01);
    _gps->putc(0x08);
    _gps->putc(0x00);
    _gps->putc(0xF0);
    _gps->putc(0x01);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x01);
    _gps->putc(0x01);
    _gps->putc(0x2B);
//GSA OFF
    _gps->putc(0xB5);
    _gps->putc(0x62);
    _gps->putc(0x06);
    _gps->putc(0x01);
    _gps->putc(0x08);
    _gps->putc(0x00);
    _gps->putc(0xF0);
    _gps->putc(0x02);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x01);
    _gps->putc(0x02);
    _gps->putc(0x32);
//GSV OFF
    _gps->putc(0xB5);
    _gps->putc(0x62);
    _gps->putc(0x06);
    _gps->putc(0x01);
    _gps->putc(0x08);
    _gps->putc(0x00);
    _gps->putc(0xF0);
    _gps->putc(0x03);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x01);
    _gps->putc(0x03);
    _gps->putc(0x39);
//VTG OFF
    _gps->putc(0xB5);
    _gps->putc(0x62);
    _gps->putc(0x06);
    _gps->putc(0x01);
    _gps->putc(0x08);
    _gps->putc(0x00);
    _gps->putc(0xF0);
    _gps->putc(0x05);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x00);
    _gps->putc(0x01);
    _gps->putc(0x05);
    _gps->putc(0x47);
//RATE 5Hz
    _gps->putc(0xB5);
    _gps->putc(0x62);
    _gps->putc(0x06);
    _gps->putc(0x08);
    _gps->putc(0x06);
    _gps->putc(0x00);
    _gps->putc(0xC8);
    _gps->putc(0x00);
    _gps->putc(0x01);
    _gps->putc(0x00);
    _gps->putc(0x01);
    _gps->putc(0x00);
    _gps->putc(0xDE);
    _gps->putc(0x6A);
}

float GPSM::trunc(float v)
{
    if (v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    } else {
        v = floor(v);
    }
    return v;
}

// GET FUNCTIONS /////////////////////////////////////////////////////////////////
float GPSM::get_nmea_longitude()
{
    return nmea_longitude;
}

float GPSM::get_dec_longitude()
{
    return dec_longitude;
}

float GPSM::get_nmea_latitude()
{
    return nmea_latitude;
}

float GPSM::get_dec_latitude()
{
    return dec_latitude;
}

float GPSM::get_course_t()
{
    return course_d;
}

float GPSM::get_speed_km()
{
    return speed_km;
}