//REFERENCE/Korišteni dijelovi koda:
//https://os.mbed.com/handbook/Ticker
//https://os.mbed.com/handbook/InterruptIn
//https://os.mbed.com/questions/5979/mbed-1768-Button-input/
//https://os.mbed.com/users/4180_1/notebook/pushbuttons/
//https://os.mbed.com/cookbook/Writing-a-Library

#include "mbed.h"
#include "flasher.h" //library

InterruptIn myButton(USER_BUTTON);
Flasher led1(D5);
Flasher led2(D4);
Flasher led3(D3);
DigitalOut myled(LED1);
Ticker blink1;
InterruptIn button(D6);
 
Flasher::Flasher(PinName pin) : _pin(pin) {
    _pin = 0;
}
 
void Flasher::flash(int n) {
    for(int i=0; i<n*2; i++) {
        _pin = !_pin;
        wait(0.2);
    }
}
 
volatile bool buttonPressed; //zastavica da je tipkalo pritisnuto
 
void onButtonPush() {
  if (myButton == 1) {  //potvrda da nije bouncing
    buttonPressed = true;
  }
}

void RADI() //potvrda da program radi ok
{
    myled = !myled;
}

void OFF() //funkcija sve ledice na nulu
{
    NVIC_SystemReset();
}


int main () {
 
 blink1.attach(&RADI, 2.0); //ticker
 
 button.mode(PullUp);
 button.rise(&OFF); //hw interrupt

 int count=0;
 
 myButton.rise(&onButtonPush); // kada pin prelazi in "0" i "1" pozovi funkciju
 
  while (1) {
 
    if (buttonPressed) { //tipkalo pritisnuto
      count++;
      buttonPressed = false; //tipkalo reset
    }
    //wait_ms(10); 
    if (count==1)
        led1.flash(2);
    else if (count==2){
        led3.flash(1);
        led1.flash(1);
        }
    else if (count==3){
        led3.flash(3);
        led2.flash(2);
        led1.flash(1);
        }
    else if (count==4){
        led3.flash(0);
        led2.flash(0);
        led1.flash(0);
        count=0;
        }
  }
 
}