#include "mbed.h"
#include "RNG/Random.h"
#include "WakeUp/WakeUp.h"

DigitalOut LED[] = {(P0_7), (P0_8), (P0_2), (P0_20), (P1_19), (P0_17), (P0_23)};// declare 7 LEDs

int rndLED = 0;
Random RNG = Random();

void myDeepSleep() {
    LPC_PMU->PCON = 0x1;
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    LPC_SYSCON->PDAWAKECFG &= 0xFFFFF800;
    __WFI();
}

void myPowerDown() {
    LPC_PMU->PCON = 0x2;
    SCB->SCR |= SCB_SCR_SLEEPDEEP_Msk;
    LPC_SYSCON->PDAWAKECFG &= 0xFFFFF800;
    __WFI();
}

void sweepMode(float delayTime)
{
        for(int x=0; x<7; x++)
        {
            LED[x] = 1;
            wait(delayTime);
        }

        for(int x=6; x>=0; x--)
        {
            LED[x] = 0;
            wait(delayTime);
        }
}

void bounceMode(float delayTime)
{
        for(int x=0; x<7; x++)
        {
            LED[x] = 1;
            wait(delayTime);
            LED[x] = 0;
        }

        for(int x=6; x>=0; x--)
        {
            LED[x] = 1;
            wait(delayTime);
            LED[x] = 0;
        }
}

void multiSweepMode(float delayTime)
{
        for(int w=1; w<13; w++)
        {            
            for(int x=1-w; x<13; x++)
            {
                    for(int z=0; z<w; z++) {
                        if(x+z>=0 && x+z < 7) {
                            LED[x+z]=1;
                        }
                    }
                    wait(delayTime);
                    for(int z=0; z<w; z++) {
                        if(x+z>=0 && x+z < 7) {
                            LED[x+z]=0;
                        }
                    }
                
            }
        }
}

void pileMode(float delayTime)
{
        for(int x=0; x<7; x++)
        {
            for(int y=0; y<(6-x); y++) {
                LED[y]=1;
                wait(delayTime);
                LED[y]=0;
            }
            LED[6-x]=1;
        }
        wait(delayTime);
        for(int x=0; x<7; x++)
        {
            LED[x] = 0;
        }
}

void randomMode(float delayTime)
{
    for(int x=0; x<128; x++) {
        rndLED = (int) RNG.getByte() % 8;
        LED[rndLED]=1;
        wait(0.01);
        LED[rndLED]=0;
        wait(delayTime);
    }
}

void binaryMode(float delayTime) {
        for(int n=0; n<128; n++) {
            for(int b=0; b<7; b++) {
                if(n & (1 << b)) {
                    LED[6 - b]=1;
                }
            }
            wait(delayTime);
            for(int b=0; b<7; b++) {
                LED[b]=0;
            }
        }
}

void grayMode(float delayTime) {
        for(int b=0; b<7; b++) { LED[b]=0; }
        
        int prev=0;
        for(int n=1; n<128; n++) {
            int prevGray = (prev >> 1) ^ prev;            
            int gray = (n >> 1) ^ n;
            int diffBit = prevGray ^ gray;
            for(int b=0; b<7; b++) {
                if(diffBit & (1 << b)) {
                    LED[6 - b] = (diffBit & prevGray) ? 0 : 1;
                    break;
                }
            }
            prev = n;
            wait(delayTime);
        }
}

void bumpMode(float delayTime) {
    for(int x=0; x<3; x++) {
        LED[x]=1;
        LED[6-x]=1;
        wait(delayTime * 2);
        LED[x]=0;
        LED[6-x]=0;
    }
    LED[3]=1;
    wait(delayTime * 2);
    LED[3]=0;
    for(int x=0; x<3; x++) {
        LED[2-x]=1;
        LED[4+x]=1;
        wait(delayTime * 2);
        LED[2-x]=0;
        LED[4+x]=0;
    }
    wait(delayTime * 4);
}

int main()
{
    while(1)
    {
        bumpMode(0.05);
        int x = (int) RNG.getByte() % 7;
        switch(x) {
            case 0:
                binaryMode(0.025);
                break;
            case 1:               
                randomMode(0.025);
                break;
            case 2:
                grayMode(0.025);
                break;                
            case 3:
                bounceMode(0.05);
                break;
            case 4:
                pileMode(0.05);
                break;
            case 5:
                multiSweepMode(0.025);
                break;
            case 6:
                sweepMode(0.05);
                break;
        }
        bumpMode(0.05);
        WakeUp::set(30);
        myPowerDown();
    }
}
