#include "mbed.h"
#include "setup.h"
#include "ssd1306.h"
#include "rtos.h"

// Threads & mutex control
Thread thread;
Thread thread1;
Thread thread2;
Thread thread3; 
Thread *(prior);
Mutex uartControl, temperatuurControl, bewegingControl, lcdControl ; 

// relais K1 & K2 
DigitalOut RelaisK1(PA_7);
DigitalOut RelaisK2(PA_6);

// ADC Temperatuursensor & bewegingssensor
AnalogIn temperatuurSensor(PA_1);
AnalogIn bewegingsSensor(PB_0);
int maxTemp = 30 ;

// Display
DigitalOut resetLCD(PB_5);
SSD1306 lcd (I2C_SDA, I2C_SCL);
int menuKnopPlaatsing = 0 ; 
int displayIsOff = 1 ; 
Timer displayOff ; 

/*
    dataModbus includes:
        RelaisK1
        RelaisK2
        Bewegingssensor
        Temperatuursensor    
    modbusOnOff turns off the modbus
*/
dataModbus values ;
int modbusOnOff = 0 ; 

//Interrupts button switches rising edge
InterruptIn switch1(PA_2);
InterruptIn switch2(PA_3);
InterruptIn switch3(PA_4);
InterruptIn switch4(PA_5);

// Temperatuurarray
static float TemperatuurArray[202] = 
{ 
3277 , 3266 , 3254 , 3243 , 3232 , 3221 , 3210 , 3199 , 3186 , 3173 ,
3160 , 3147 , 3134 , 3121 , 3108 , 3095 , 3082 , 3069 , 3056 , 3043 ,
3030 , 3017 , 3004 , 2991 , 2978 , 2965 , 2952 , 2938 , 2925 , 2912 ,
2899 , 2886 , 2873 , 2859 , 2846 , 2833 , 2820 , 2807 , 2793 , 2780 ,
2767 , 2754 , 2740 , 2727 , 2714 , 2700 , 2687 , 2674 , 2660 , 2647 , 
2633 , 2620 , 2607 , 2593 , 2580 , 2567 , 2553 , 2540 , 2527 , 2513 ,
2500 , 2486 , 2473 , 2459 , 2446 , 2433 , 2419 , 2406 , 2392 , 2379 ,
2365 , 2352 , 2338 , 2325 , 2311 , 2298 , 2285 , 2271 , 2258 , 2244 , 
2231 , 2217 , 2204 , 2190 , 2176 , 2163 , 2149 , 2136 , 2122 , 2108 ,
2095 , 2081 , 2067 , 2054 , 2040 , 2026 , 2012 , 1999 , 1985 , 1971 , 
1958 , 1944 , 1930 , 1916 , 1902 , 1888 , 1875 , 1861 , 1847 , 1833 , 
1819 , 1805 , 1791 , 1777 , 1763 , 1749 , 1735 , 1721 , 1707 , 1693 , 
1679 , 1665 , 1651 , 1637 , 1623 , 1609 , 1595 , 1581 , 1567 , 1553 ,
1539 , 1525 , 1511 , 1497 , 1483 , 1469 , 1455 , 1441 , 1427 , 1413 , 
1399 , 1385 , 1371 , 1356 , 1342 , 1328 , 1314 , 1300 , 1286 , 1272 , 
1257 , 1243 , 1229 , 1215 , 1201 , 1186 , 1172 , 1158 , 1144 , 1130 ,
1115 , 1101 , 1087 , 1073 , 1058 , 1044 , 1030 , 1015 , 1001 , 987  ,
973  , 958  , 944  , 929  , 915  , 901  , 886  , 872  , 858  , 843  ,
829  , 814  , 800  , 786  , 771  , 757  , 742  , 728  , 713  , 699  ,
684  , 670  , 655  , 640  , 626  , 611  , 597  , 582  , 568  , 553  ,
538
};

/*
    knoppen functionaliteit:
        omhoog
        omlaag
        select
        back
*/
void omhoog(void) 
{
    menuKnopPlaatsing = 1 ; 
}
void omlaag(void) 
{
    menuKnopPlaatsing = 2 ; 
}
void select(void) 
{
    menuKnopPlaatsing = 3 ; 
}
void back(void) 
{
    menuKnopPlaatsing = 4 ; 
}
/*
    modbusRunning thread 
*/
void modbusRunning() 
{
    static int checkReturnValue = 0 ;
    // waardes initialiseren
    values.RelaisK1 = 0;    // ventilator
    values.RelaisK2 = 0;    // Lamp
    values.temperatuur = 0 ; 
    values.beweging = 0 ;    
    values.slaveID = 0x07 ; 

    while(true)
    {
        if ( modbusOnOff == 1 ) 
        {
            uartControl.lock();
            checkReturnValue = modbus_read(&values) ;
            switch(checkReturnValue)
            {
                case 1 :
                    RelaisK1 = 1 ; 
                    RelaisK2 = 1 ;
                    break ; 
                case 2 :
                    RelaisK1 = 0 ;
                    RelaisK2 = 1 ;
                    break ;
                case 3 :
                    RelaisK1 = 1 ;
                    RelaisK2 = 0 ; 
                    break ;
                case 4 :
                    RelaisK1 = 0 ; 
                    RelaisK2 = 0 ;
                    break ; 
                default:
                break;                          
            }
            uartControl.unlock();      
        }  
    }
}
/*
    temperatuurSensorRunning thread1 
*/
void temperatuurSensorRunning()
{
    static float average = 0 , sum = 0 , Average16[16] ; 
    static int  i = 0, arrayNumber = 0 ; 
    int temp = 0 ; 
    while(true)
    {
        // circulaire array van 16
        if ( arrayNumber == 16 )
        {
            arrayNumber = 0 ;    
        }
        temperatuurControl.lock();
        Average16[arrayNumber] = temperatuurSensor ; 
        temperatuurControl.unlock();        
        arrayNumber++;
        sum = 0 ;
        for( i = 0 ; i < 16 ; i++ )
        {
            //optellen en gemiddelde nemen
            sum += Average16[i];
        }
        //gemiddelde van 16 waardes vermenigvuldigen met de maximale waarde
        average = (sum / 16) * 3300 ; 
        i = 0 ; 
        int x = 1 ; 
        while(x)
        {
            if ( average > TemperatuurArray[i+1] && average < TemperatuurArray[i] ) 
            {
                // uit while loop juiste referentie waarde gevonden
                x = 0 ; 
                // message the temperatuur door int i
                temp = i ;
                temperatuurControl.lock(); 
                values.temperatuur = temp-52 ;    
                temperatuurControl.unlock();  
            }
            else 
            {
                i++;
            }
        }
        // modbus niet aan temperatuur wordt hier geregeld. 
        if ( values.temperatuur > maxTemp && modbusOnOff == 0 )
        {
            RelaisK1 = 1 ;   // ventilator
        }
        // modbus niet aan temperatuur wordt hier geregeld. 
        else if( values.temperatuur < maxTemp && modbusOnOff == 0)
        {
            RelaisK1 = 0 ;  // ventilator
        }
        else
        {}
    }
}
/*
    bewegingsSensorRunning thread2
*/
void bewegingsSensorRunning()
{
    float bewegingssensorADC = 0 ; 
    while(true)
    {
        bewegingControl.lock();
        bewegingssensorADC = bewegingsSensor ; 
        bewegingControl.unlock();
        if(  bewegingssensorADC < (float)0.4 ) 
        {
            // message beweging gedetecteerd
            // zet lamp aan
            bewegingControl.lock();
            values.beweging = 1 ; 
            bewegingControl.unlock();
            //wait_ms(200);
            //wait(1);
            if ( displayIsOff == 0 ) 
            {
                menuKnopPlaatsing = 1 ; 
                displayIsOff = 1 ;
            }
        }
        else 
        {
            // geen beweging gezien
            bewegingControl.lock();
            values.beweging = 0 ; 
            bewegingControl.unlock();
        }
        
        // modbus niet aan temperatuur wordt hier geregeld. 
        if( modbusOnOff == 0 && displayIsOff == 1 )
        { 
            RelaisK2 = 1 ;   // lamp
        }
        // modbus niet aan temperatuur wordt hier geregeld. 
        else if(modbusOnOff == 0 && displayIsOff == 0  )
        {
            RelaisK2 = 0 ;  // lamp
        }
        else
        {
        }        
    }
}
/*
    displayRunning thread3
*/
void displayRunning()
{ 
    resetLCD = 1 ;
    resetLCD = 0 ;
    resetLCD = 1 ;
    lcdControl.lock();
    lcd.speed(SSD1306::Fast);
    lcdControl.unlock();
    lcdControl.lock();
    lcd.init();
    lcdControl.unlock();
    lcdControl.lock();
    lcd.bitMap();
    lcd.redraw();
    lcdControl.unlock();
    int plaats = 1 ;  
    displayOff.start();
    while(true)
    {
        if ( menuKnopPlaatsing != 0 ) 
        {
            displayIsOff = 1 ;
            displayOff.start();
            displayOff.reset();
            // knop functionaliteit
            switch(menuKnopPlaatsing)
            {
                case 1 :
                    //omhoog
                    plaats--;
                break;
                case 2 :
                    //omlaag
                    plaats++; 
                break; 
                case 3 :
                    // select
                    switch(plaats)
                    {
                        case 1:
                            plaats = 7 ; 
                        break ; 
                        case 2:
                            plaats = 10; 
                        break;
                        case 10 :
                            plaats = 16 ;
                        break; 
                        case 11 :
                            plaats = 19 ; 
                        break;
                        case 12 :
                            plaats = 22 ; 
                        break;
                        case 13 :
                            plaats = 26 ; 
                        break;
                        case 22: 
                            // turn on relais  
                            RelaisK1 = 0 ; 
                        break;
                        case 23:
                            // turn off relais
                            RelaisK1 = 1 ; 
                        break; 
                        case 26:
                            // turn on relais K2
                            RelaisK2 = 0 ; 
                        break;
                        case 27:
                            // turn off relais K2
                            RelaisK2 = 1 ; 
                        break; 
                        case 7 :
                            plaats = 30 ; 
                        break;
                        case 5:
                            plaats = 33 ;
                        break;
                        case 33:
                            // start proces modbus
                            modbusOnOff = 1 ; 
                        break;
                        case 34:
                            // terminate proces modbus
                            modbusOnOff = 0 ;                             
                        break;
                        case 6:
                            plaats = 37 ;
                        break;
                        default:
                            //plaats = 1 ; 
                        break ; 
                    }
                break ; 
                case 4 :
                    //back
                    switch(plaats)
                    {
                        case 5:
                            plaats = 1 ; 
                        break ; 
                        case 6:
                            plaats = 1; 
                        break;
                        case 7:
                            plaats = 1;
                        break;
                        case 10:
                            plaats = 2 ; 
                        break ; 
                        case 11:
                            plaats = 2; 
                        break;
                        case 12:
                            plaats = 2; 
                        break;
                        case 13:
                            plaats = 2;
                        break;
                        case 16: 
                            plaats = 10 ; 
                        break; 
                        case 19:
                            plaats = 11 ; 
                        break; 
                        case 22:
                            plaats = 12 ;
                        break; 
                        case 23:
                            plaats = 12 ;
                        break;
                        case 26: 
                            plaats = 13 ; 
                        break; 
                        case 27: 
                            plaats = 13 ; 
                        break;                         
                        case 30:
                            plaats = 7 ;
                        break ;  
                        case 33:
                            plaats = 5 ;
                        break;
                        case 34:
                            plaats = 5 ;
                        break;
                        case 37 :
                            plaats = 6 ;
                        break; 
                        default:
                            plaats = 1 ; 
                        break ; 
                    }
                break ; 
                default :
                break; 
            }
            // loop maken omhoog/omlaag
            switch(plaats)
            {
                // menu deel 1
                case 0:
                    plaats = 2 ;
                break ;
                case 3:
                    plaats = 1 ;
                break ; 
                // menu deel 2
                case 4:
                    plaats = 7 ;
                break ;
                case 8:
                    plaats = 5 ;
                break ; 
                // menu deel 3
                case 9:
                    plaats = 13 ;
                break ;
                case 14:
                    plaats = 10 ;
                break ; 
                // menu deel 4
                case 15:
                    plaats = 16 ; 
                break;
                case 17:
                    plaats = 16 ; 
                break; 
                case 18 :
                    plaats = 19 ; 
                break;
                case 20 :
                    plaats = 19 ; 
                break; 
                case 21 :
                    plaats = 23 ; 
                break;
                case 24 :
                    plaats = 22 ;
                break;
                case 25 : 
                    plaats = 27 ; 
                break; 
                case 28 :
                    plaats = 26 ; 
                break;
                case 29:
                    plaats = 30 ;
                    values.slaveID++;
                break;
                case 31:
                    plaats = 30 ; 
                    values.slaveID--;
                break; 
                case 32:
                    plaats = 34 ; 
                break;
                case 35:
                    plaats = 33 ; 
                break;
                case 36:
                    plaats = 37 ; 
                    maxTemp++;
                break ; 
                case 38:
                    plaats = 37 ; 
                    maxTemp--;
                break; 
                default:
                break;                 
            }
            
            menuKnopPlaatsing = 0 ; 
            lcd.cls();
            lcd.locate(0,0);
            switch(plaats)
            {
                case 1 :
                    lcd.printf("settings[x]");
                    lcd.locate(1,0);
                    lcd.printf("data[]");
                break ;
                case 2 :
                    lcd.printf("settings[]");
                    lcd.locate(1,0);
                    lcd.printf("data[x]");
                break;
                case 5 :
                    lcd.printf("modbus");
                    lcd.locate(1,0);
                    lcd.printf("on/off[x]");
                break;
                case 6 :
                    lcd.printf("temp");
                    lcd.locate(1,0);
                    lcd.printf("max[x]");
                break;
                
                case 7 :
                    lcd.printf("modbus");
                    lcd.locate(1,0);
                    lcd.printf("adres[x]");
                break;
                case 10 :
                    lcd.printf("temp[x]");
                    lcd.locate(1,0);
                    lcd.printf("beweging[]");
                break;
                case 11 :
                    lcd.printf("temp[]");
                    lcd.locate(1,0);
                    lcd.printf("beweging[x]");
                break;
                case 12 :
                    lcd.printf("relaisK1[x]");
                    lcd.locate(1,0);
                    lcd.printf("relaisK2[]");
                break;
                case 13 :
                    lcd.printf("relaisK1[]");
                    lcd.locate(1,0);
                    lcd.printf("relaisK2[x]");
                break;
                case 16 :
                    lcd.printf("temp:");
                    lcd.locate(1,0);
                    lcd.printf("%d" , values.temperatuur);
                break;                
                case 19 :
                    lcd.printf("beweging:");
                    lcd.locate(1,0);
                    lcd.printf("%d" , values.beweging );
                break;
                case 22 :
                    lcd.printf("K1 aan[]");
                    lcd.locate(1,0);
                    lcd.printf("K1 uit[x]");
                break;
                case 23 :
                    lcd.printf("K1 aan[x]");
                    lcd.locate(1,0);
                    lcd.printf("K1 uit[]");
                break;
                case 26 :
                    lcd.printf("K2 aan[]");
                    lcd.locate(1,0);
                    lcd.printf("K2 uit[x]");
                break;                
                case 27 :
                    lcd.printf("K2 aan[x]");
                    lcd.locate(1,0);
                    lcd.printf("K2 uit[]");
                break;
                case 30 :
                    lcd.printf("modadres");
                    lcd.locate(1,0);
                    lcd.printf("%d" , values.slaveID);                
                break ;
                case 33:
                    lcd.printf("Mod aan[x]");
                    lcd.locate(1,0);
                    lcd.printf("Mod uit[]");                    
                break;
                case 34:
                    lcd.printf("Mod aan[]");
                    lcd.locate(1,0);
                    lcd.printf("Mod uit[x]");                    
                break;  
                
                case 37 :
                    lcd.printf("max temp");
                    lcd.locate(1,0);
                    lcd.printf("%d" , maxTemp);                
                break ;                
                
                                       
                default:
                    lcd.printf("error 1");
                break;    
            }
            lcd.redraw();
            wait(1); 
         }
         else
         {
            wait(1);   
            if(displayOff.read() > (float)60)
            {
                // turn off display after 60 seconds
                lcd.cls();
                lcd.cls();
                lcd.redraw();   
                displayOff.stop();
                displayOff.reset();
                plaats = 1 ; 
                displayIsOff = 0 ; 
            }
         } 
    }
}

int main() 
{
    // interrupt menu switches
    switch1.rise(omhoog);
    switch2.rise(omlaag);
    switch3.rise(select);
    switch4.rise(back);

    //prioriteit modbus hoog    
    prior = &thread ; 
    prior->set_priority(osPriorityHigh);
    //prioriteit temperatuur & beweging normaal    
    prior = &thread1 ; 
    prior->set_priority(osPriorityNormal);
    prior = &thread2 ; 
    prior->set_priority(osPriorityNormal);
    //prioriteit display laag
    prior = &thread3 ; 
    prior->set_priority(osPriorityBelowNormal);
    
    //Modbus
    thread.start(modbusRunning);
    //Temperatuursensor
    thread1.start(temperatuurSensorRunning);
    //Bewegingssensor
    thread2.start(bewegingsSensorRunning);
    // Display
    thread3.start(displayRunning);

}


