/* mbed software with debugger
 *
 * author : Mike van Doorn
 *
 */

#include "mbed.h"
#define slaveAdress     0x07
#define functioncode    0x02

Serial pc(USBTX, USBRX);
Serial bus(PA_9,PA_10);
DigitalOut led1(LED1);
DigitalOut activateSN65(PA_8);
int Read(void); 

int main()
{
    int count = 0 ;
    int data = 0 ; 
    int buffer = 0 ;
    int value = 0 ;
    activateSN65 = 0 ;
    pc.baud(115200);
    wait(1);
    
    while(1)
    {
        if ( count == 10 )
        {
            count = 0 ;     
        }
        activateSN65 = 0 ;
        if(bus.readable())
        { 
            data = bus.getc();
            pc.putc(data);
            if ( data == slaveAdress && buffer == 0) 
            {
               buffer = 1;      // check slava adress
            }
            else if ( data == functioncode && buffer == 1)
            {
                buffer = 2;     // check functioncode
            } 
            else if ( buffer == 2 || buffer == 3 )
            {
               // adress high and low 
               if ( buffer == 2 ) 
               {
                   buffer = 3 ; // check starting adress hi
               }
               else
               {
                    value = value + data ;
                    buffer = 4 ; // check starting adress low
               }                      
            }
            else if ( buffer == 4 )
            {
                // no of points hi 
                buffer = 5 ;     
            }
            else if ( buffer == 5 )
            {
                // no of points lo 
                buffer = 6 ;    
            }
            else if ( buffer == 6 ) 
            {
                //crc check  
                buffer = 7 ;   
            }    
            else if ( buffer == 7 )
            {
                //crc check    
                buffer = 8 ; 
            }
            else 
            {
                buffer = 0 ;     
            }
              
        }
        if ( buffer == 8 )
        {
            if ( count < 5 )
            {
                led1 = !led1; 
                wait_ms(3);
                activateSN65 = 1 ; 
                //adress
                bus.putc(slaveAdress);
                wait_us(900);
                //send function code
                bus.putc(functioncode);
                wait_us(900);
                // Byte count
                bus.putc(0x02);
                wait_us(900); 
                //data
                bus.putc(0x01);
                wait_us(900);
                //data
                bus.putc(0x00);
                wait_us(900);
                // crc check 
                bus.putc(0x31);
                wait_us(900);
                bus.putc(0xD4);
                buffer = 0 ; 
                wait_ms(2) ;
                activateSN65 = 0 ; 
                count++;
            }
            else 
            {
                led1 = !led1; 
                wait_ms(3);
                activateSN65 = 1 ; 
                //adress
                bus.putc(slaveAdress);
                wait_us(900);
                //send function code
                bus.putc(functioncode);
                wait_us(900);
                // Byte count
                bus.putc(0x02);
                wait_us(900); 
                //data
                bus.putc(0x02);
                wait_us(900);
                bus.putc(0x02);
                wait_us(900);
                // crc check 
                bus.putc(0xB0);
                wait_us(900);
                bus.putc(0xE5);
                buffer = 0 ; 
                wait_ms(2) ;
                activateSN65 = 0 ; 
                count++;
            }
        }
            
    }

}