#include "mbed.h"
#include "setup.h"
#include "ssd1306.h"

//UART to RS485 bus line & enable of RS485
Serial bus(PA_9,PA_10); //rx , tx
DigitalOut activateSN65(PA_8);

// Timer max message time
Timer maxMessageTime ; 

// buffer message package
unsigned static int buffer = 0;

unsigned int dataReceived[10] ; 
unsigned int dataSend[10] ; 
unsigned int count = 0, count1 = 0, count2 = 0   ; 
static unsigned int maxSizeBuffer = 0 ; 

int modbus_read(dataModbus *allData)
{
    activateSN65 = 0 ;

    if(bus.readable())
    {
//        if( maxMessageTime.read_ms() > (int)180 )
//        {
//            buffer = 0 ;  
//            maxMessageTime.reset();  
//        }
        int data = bus.getc(); 
        if ( data == allData->slaveID && buffer == 0 ) 
        {
//            maxMessageTime.start();
            dataReceived[buffer++] = allData->slaveID ;   // slaveID checks out proceed to checking function ID 
        }
        else if ( buffer == 1 )
        {
             dataReceived[buffer++] = data ;     // functie code
             maxSizeBuffer = functionCodeCheckMaxData(data) ;
        }
        else if ( ( buffer >= 2 ) && ( buffer <  maxSizeBuffer ) )
        {
            dataReceived[buffer++] = data ;     // data 
        } 
        else if ( buffer == maxSizeBuffer || buffer == maxSizeBuffer + 1 ) 
        {
            if (buffer == maxSizeBuffer )
            {
                dataReceived[buffer++] = data ;
            }
            else 
            {
                dataReceived[buffer++] = data ;  
                //buffer++; 
                CRCChecking();
            }
        }
        else 
        {
            buffer = 0 ;  
//            maxMessageTime.stop();
//            maxMessageTime.reset();  
        } 
    }
    if ( buffer == maxSizeBuffer + 3 ) 
    {
//        maxMessageTime.stop();
//        maxMessageTime.reset();
        return modbus_sendData(allData);
    }
    
    return 0 ; 
}

int modbus_sendData(dataModbus *allData)
{
    int i = 0 ;
    int maxData = 0 ; 
    static int temperatuur = 0, beweging = 0 ; 
    temperatuur = allData->temperatuur ; 
    beweging = allData->beweging ; 
    dataSend[maxData++] = allData->slaveID ; 
    dataSend[maxData++] = dataReceived[1];
    if ( dataReceived[1] == 0x02 ) 
    {
        dataSend[maxData++] = 0x01 ;          // byte count
        dataSend[maxData++] = 0x01 ;
    }
    else if (dataReceived[1] == 0x04 )
    {
        if ( dataReceived[3] == 0 )
        {
            dataSend[maxData++] = 0x02 ;        // byte count
            dataSend[maxData++] = 0x00 ; 
            dataSend[maxData++] = temperatuur ;
        }
        else 
        {
            dataSend[maxData++] = 0x02 ;        // byte count
            dataSend[maxData++] = 0x00 ; 
            dataSend[maxData++] = beweging ;
        }
    }
    else if ( dataReceived[1] == 0x06 )
    {
        dataSend[maxData++] = dataReceived[2] ;     //echo
        dataSend[maxData++] = dataReceived[3] ;
        dataSend[maxData++] = dataReceived[4] ;
        dataSend[maxData++] = dataReceived[5] ;
        if ( dataReceived[3] == 0x01 ) 
        {
            count2 = dataReceived[5] ;
            if ( count2 == 1 )
            {
                allData->RelaisK1 = 1 ;
            }
            else 
            {
                allData->RelaisK1 = 0 ; 
            }     
        }
        else 
        {
            count1 = dataReceived[5] ;
            if ( count1 == 1 )
            {
                allData->RelaisK2 = 1 ; 
            }
            else 
            {
                allData->RelaisK2 = 0 ; 
            }
        }
        temperatuur = allData->temperatuur ; //count2 * count1 ; 
        beweging = allData->beweging ;
    } 
    else 
    { 
        return 0 ; 
    }
    uint16_t temp = calculate_crc16_Modbus(dataSend, maxData ) ; 
    dataSend[maxData++] = (uint8_t)temp ; 
    dataSend[maxData++] = ((uint16_t)temp>>8); 
    activateSN65 = 1 ; 
    wait_ms(3);
    for(i = 0 ; i < maxData ; i++ )
    {
        bus.putc(dataSend[i]);
        wait_us(750);
    }
   
    buffer = 0 ; 
    wait_ms(2) ;
    activateSN65 = 0 ; 
    
    if ( allData->RelaisK1 == 1 && allData->RelaisK2 == 1 )
    {
        return 1 ; 
    }
    else if ( allData->RelaisK1 == 0 && allData->RelaisK2 == 1 )
    {
        return 2 ;    
    }
    else if ( allData->RelaisK1 == 1 && allData->RelaisK2 == 0 )
    {
        return 3 ;    
    }
    else if ( allData->RelaisK1 == 0 && allData->RelaisK2 == 0 )
    {
        return 4 ;    
    }
    else 
    {
        return 0 ;         
    }

}

uint16_t update_crc16_reflected(const uint16_t *table, uint16_t crc, unsigned int c )
{
    long short_c;

    short_c  = 0x00ff & (long) c;

    /* Reflected form */
    return (crc >> 8) ^ table[(crc ^ short_c) & 0xff];
}


uint16_t update_crc16_A001( long crc, unsigned int c )
{
    return update_crc16_reflected(crc_tab_8005_reflected,crc,c);
}


long calculate_crc16_Modbus(unsigned int *p, unsigned int length)
{
    long crc;
    unsigned int i;

    crc = 0xFFFF;

    for (i=0; i < length; i++)
    {
        crc = update_crc16_A001(crc,*p++);
    }
    return crc;
}

int functionCodeCheckMaxData(int functionCode)
{
    // exclude function code in byte count
    switch (functionCode) 
    {
        // function code 0x01
        case 0x02 :
            return 0x04 + 2 ;  
            //break ;
        case 0x04 :
            return 0x04 + 2 ;  
            //break ; 
        case 0x06 :
            return 0x04 + 2 ;
        default :
            buffer = 0 ; 
            return 0 ;  
    }
}
void CRCChecking(void)
{
    unsigned long crc = ((dataReceived[buffer - 1] << 8) | dataReceived[buffer - 2]); // combine the crc Low & High bytes 
    if ( calculate_crc16_Modbus(dataReceived, buffer - 2 ) == crc )
    {
        buffer++  ; 
    }
    else 
    {
        buffer = 0 ; 
    }  
}