///////////////////////
///
///     EVKIT
///
///////////////////////
#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "string"
#include "iostream" // std::hex




using namespace std;

// Hardware serial port over DAPLink
Serial daplink(P2_1, P2_0);

// Virtual serial port over USB
USBSerial microUSB; 

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

// SPI pins
DigitalOut clk(P5_0);
DigitalInOut data(P5_1); 
DigitalOut csb(P3_0);

// Control pins
DigitalOut pwrdn(P4_0);

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

// subroutines
int ascii(char a, char b);
int ldo(char a, char b);
int spiWrite( char a, char b);
int spiRead( char a );
int h( char a );

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    int c;
    char buf[30]; // strings entered can only be 30 characters
    

    daplink.printf("daplink serial port\r\n");
    microUSB.printf("micro USB serial port\r\n");
    rLED = LED_OFF;
    gLED = LED_OFF;
    bLED = LED_OFF;

    data.output();
    
    csb = 1;
    clk = 0;
    data = 0;
    pwrdn = 1;
    
    pegasus.max14690.ldo3SetVoltage(3000);
    pegasus.max14690.ldo2SetVoltage(3000);
    wait(1.0);
    gLED=LED_ON;
    wait_ms(500);
    gLED=LED_OFF;
    rLED=LED_ON;
    wait_ms(500);
    rLED=LED_OFF;
    bLED=LED_ON;
    wait_ms(500);
    bLED=LED_OFF;
    wait_ms(500);
    gLED=LED_ON;

    while(1) {
        microUSB.scanf("%s", buf);
        wait_us(10);
        
        if( strlen(buf) > 0 ) {

            // ping command, responds with pong
            if(strncmp(buf,"ping", 4)==0) {
                microUSB.printf("pong\r\n");
                gLED=LED_ON;
                wait(0.01); // in seconds
                gLED=LED_OFF;
                wait(0.01);
                gLED=LED_ON;
            }
            
            // "evkit"
            else if ( strncmp(buf, "evki", 4 )==0 ) {
                microUSB.printf("true\r\n");
            }
            
             // spi write command: spiw.addr.data
            // addr and data in hex
            else if (strncmp(buf,"spiw",4)==0) {
                int resp = 0;
                // payload[0] is address
                // payload[1] is data
                char payload[2];
                payload[0] = ascii((int)buf[5],(int)buf[6]);
                payload[1] = ascii((int)buf[8],(int)buf[9]);
                resp = spiWrite(payload[0], payload[1]);
                microUSB.printf("ack.%i\r\n",resp);
                gLED=LED_OFF;
                wait(0.01); // in seconds
                gLED=LED_ON;
                wait(0.01);
                gLED=LED_OFF;
            }           

            else if (strncmp(buf, "spir",4)==0) {
                int resp = 0;
                char payload[1];
                payload[0] = ascii((int)buf[5],(int)buf[6]);
                resp = spiRead(payload[0]);
                microUSB.printf("ack.%i\r\n", resp);
                gLED=LED_OFF;
                wait(0.01); // in seconds
                gLED=LED_ON;
                wait(0.01);
                gLED=LED_OFF;
            }

            else if (strncmp(buf, "pwrdn",5)==0) {
                int val;
                if( buf[6] == 48 ) { val=0; gLED=LED_ON; rLED=LED_OFF; }
                else { val=1;gLED=LED_OFF; rLED=LED_ON; }
                pwrdn = val;
                microUSB.printf("ack.%i\r\n",val);
            }
            
            else if (strncmp(buf, "scan",4)==0) {
                // send 1000 clocks with a 1100 pattern on data
                // csb=1 since that is SCAN_EN
                // SEL1/NC=SCAN_RESET is not controlled via feather
                int val;
                int i;
                csb = 1;
                for(i = 0; i<500; i++) {
                    clk = 0;
                    data = (data==0)?1:0;
                    wait_us(1);
                    clk = 1;
                    wait_us(1);
                    clk = 0;
                    wait_us(1);
                    clk = 1;
                    wait_us(1);
                }
                microUSB.printf("scan ack.%i\r\n",val);
            }
            // set ldo voltage
            else if (strncmp(buf,"ldo",3)==0) {
                int setting = ldo((int)buf[4],(int)buf[5]);
                //microUSB.printf("Setting:%i\r\n",setting);
                pegasus.max14690.ldo3SetVoltage(setting*100);
                pegasus.max14690.ldo2SetVoltage(setting*100);
                wait(0.01);
                microUSB.printf("ack.%i\r\n",setting);
                gLED=LED_ON;
                wait(0.01); // in seconds
                gLED=LED_OFF;
                wait(0.01);
                gLED=LED_ON;
            }
        }
   }
   
}

int spiWrite( char address, char dat ) {
    int i = 0;
    csb = 0;
    wait_us(1.0);
    
    // first write address
    for( i = 7; i>=0; i--) {
    
        clk = 0;
        wait(0.000001);
        data = (1<<i) & address;
        wait(0.000001);
        clk = 1;
        wait(0.000002);
    }
    for( i = 7; i>=0; i--) {
        clk = 0;
        wait(0.000001);
        data = (1<<i) & dat;
        wait(0.000001);
        clk = 1;
        wait(0.000002);
        }
    csb = 1;
    clk = 0;
    return 1;
    
}

int spiRead( char address ) {
    int i = 0;
    int dat = 0;
    clk =0 ;
    csb = 0;
    wait_us(1);
    
   // first write address  
    for( i = 7; i>=0; i--) {
        clk = 0;
        wait_us(1);
        data = (1<<i) & address;
        wait_us(1);;
        clk = 1;
        wait_us(1);
    }
    // load dummy byte, all zeros in this case
    data = 0;
    for( i = 7; i>=0; i--){
        clk = 0;
        wait_us(1);
        clk = 1;
        wait_us(1);
      }
    // read byte from part
    data.input();
    for( i = 7; i>=0; i--){
        clk = 0;
        wait_us(2);
        clk = 1;
        if(data > 0) dat = dat + (1<<i);
        wait_us(1);
    }
    data.output();
    clk = 0;
    csb = 1;
    return dat;
}

int h(char a)
{
    int intval = (a >= 'A') ? (a - 'A' + 10) : (a - '0');
    return intval;
}

int ascii(char a, char b)
{
    int val1 = 0;
    int val2 = 0;
    int val = 0;
    if(a>64 && a<71)
    {
        val1 = (int)a-55;
    }
    else if(a>96 && a<103)
    {
        val1 = (int)a-87;
    }
    else val1 = (int)a-48;
    
    if(b>64 && b<71)
    {
        val2 = (int)b-55;
    }
    else if(b>96 && b<103)
    {
        val2 = (int)b-87;
    }
    else val2 = (int)b-48;
    
    val=16*val1+val2;
    
    return val;
}

int ldo(char a, char b)
{
    int val1 = 0;
    int val2 = 0;
    int val = 0;
    if(a>64 && a<71)
    {
        val1 = (int)a-55;
    }
    else if(a>96 && a<103)
    {
        val1 = (int)a-87;
    }
    else val1 = (int)a-48;
    
    if(b>64 && b<71)
    {
        val2 = (int)b-55;
    }
    else if(b>96 && b<103)
    {
        val2 = (int)b-87;
    }
    else val2 = (int)b-48;
    
    val=10*val1+val2;
    
    return val;
}    