
#include "mbed.h"
#include "mcp4725.h"
#include "math.h"
#include <iostream>
using namespace std;

/**
 * A test program for the MCP4725 DAC Library. This Test Application requires the following:
 *  * An MCP4725 connected to the I2C bus of the mbed LPC1768.
 *  * The analog out of the MCP1768 connected to Pin15 (analog in) of the mbed LPC1768.
 *  
 *
 * This is a stripped down version of the MCP4725_Library_Test found online, and should make the necessary commands more clear.
 * Last Edited: 12/24/13, Tim Brubaker
 *
 */

DigitalOut testLed(LED1);
Serial pc(USBTX, USBRX);
AnalogIn analogIn(p15);
CAN can1(p30,p29);

// Class instantiation (similar to Serial pc(USBTX, USBRX) in function)
MCP4725 bacon(p9, p10, MCP4725::Fast400kHz, 0x63);
      
float xrad = 0;
float x = 0;

int main()
{
    float xrad = 0;
    float x = 0;
    int state = 5;
    int mem = 0;
    //
//
//
    while (1) {
        CANMessage msg;
        if(can1.read(msg)){
            printf("Message received: %d\n", msg.data[0]);
            switch(msg.data[0]){
             case 0:
                state = mem;
                break;
                
             case 1:
                mem = state;
                state = 1;
                break;
                
             case 2:
               state = 2;
               break;     
                          
             case 3:       
                state = 3;
                break;
                
            case 4:
                state = 4;
                break;   
                
             case 5 :
                state = 5;
                break;
            }    
        }
     switch (state){
         case 0:
            //pc.printf("Start");
            break;
         case 1:
            bacon.write(MCP4725::Normal, (0xFFF * (0.0 / 3.3)), false);
            pc.printf("Value is %f V \r\n", analogIn.read()*3.3);
            break;
         
         case 2:
            testLed = 1;
            wait(1);
            // Write to DAC register (not EEPROM). Documentation in library files.
            bacon.write(MCP4725::Normal, (0xFFF * (3.3 / 3.3)), false);
            testLed = 0;
               pc.printf("Value is %f V \r\n", analogIn.read()*3.3);
               wait(1);
               bacon.write(MCP4725::Normal, (0xFFF * (0.0 / 3.3)), false);
              // Print ADC measurement to terminal. Scale factor of 3.3 needed for internal ADC.
             pc.printf("Value is %f V \r\n", analogIn.read()*3.3);
             break;
         
         case 3:
            // printf("1 Hz Sine Wave\r\n");
            //1 Hz Sine Wave
            xrad = x*3.14159 / 180;
            // Write to DAC register (not EEPROM). Documentation in library files.
            bacon.write(MCP4725::Normal, (0xFFF * (0.5*sin(xrad) + 0.5)), false);
            if (x == 360){
                x = 0.045;
            }
            else {
                x = x + 0.045;
            }
            break;
         case 4:
            wait(.1);
            bacon.write(MCP4725::Normal, (0xFFF * (3.3 / 3.3)), false);
            testLed = 0;
            pc.printf("Value is %f V \r\n", analogIn.read()*3.3);
            wait(0.1);
            bacon.write(MCP4725::Normal, (0xFFF * (0.0 / 3.3)), false); 
            // Print ADC measurement to terminal. Scale factor of 3.3 needed for internal ADC.
            pc.printf("Value is %f V \r\n", analogIn.read()*3.3);
            break;
         case 5:
        
            // Write to DAC register (not EEPROM). Documentation in library files.
            xrad = x*3.14159 / 180;
            // Write to DAC register (not EEPROM). Documentation in library files.
            bacon.write(MCP4725::Normal, (0xFFF * (0.5*sin(xrad) + 0.5)), false);
            if (x == 360){
                x = 0.45;
            }
            else {
                x = x + 0.45;
            }
            break;
        }
   }
}