#include "mbed.h"
// Need include below to add the RTOS
#include "rtos.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "RGBLed.h"
#include <string>

 


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//wave player plays a *.wav file to D/A and a PWM
AnalogOut DACout(p18);
wave_player waver(&DACout);

uLCD_4DGL uLCD(p28,p27,p26); // serial tx, serial rx, reset pin;
SDFileSystem sd(p5, p6, p7, p8, "sd");
RGBLed rgb(p22, p23, p24);
Mutex uLCD_mutex;
Mutex seed_mutex;

volatile float seed = 0;
// Setup function code for three new threads to run.
// Put in a while loop so that threads run forever.
// Thread::wait will force at least a "x" millisecond
// wait before the thread runs again. During this delay
// the other threads will run
// DO NOT use wait() with the RTOS!!!!!
// wait just burns processor time and no other threads run
void audio_thread(void const *argument)
{
    FILE *fp = fopen("/sd/mydir/Evil_Laugh.wav", "r");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    while (true) {
        waver.play(fp);
    }
}
void uLCD2_thread(void const *argument)
{
    float old_seed = 1;
    while (true) {
        if (old_seed != seed){
            old_seed = seed;
            uLCD_mutex.lock();
            uLCD.filled_rectangle(30, 30, 120, 10,BLACK);
            uLCD.filled_rectangle(30, 30, 120*seed, 10, RED);
            uLCD_mutex.unlock();
        
        }
    }
}
void RGB_thread(void const *argument)
{
    while (true) {
        
        //seed_mutex.lock();
        seed = rand()/float(RAND_MAX);
        //seed_mutex.unlock();
        rgb.write(seed/9 ,seed/5, seed/4+.2); //Blue, green,red;
        Thread::wait(150);
    }
}

int main()
{
    uLCD.cls();
    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
    uLCD.text_width(2); //2x size text
    uLCD.text_height(2);
    uLCD.text_italic(ON);
    uLCD.background_color(BLACK);
    Thread thread1(uLCD2_thread);
    Thread thread2(audio_thread);
    Thread thread3(RGB_thread);
    led1 = 1;
    //Problems using c_str()

    while (true) {
        led2 = !led2;

        uLCD_mutex.lock();
        uLCD.locate(0,5);
        uLCD.printf("SPOOKY!    ");
        uLCD_mutex.unlock();
        Thread::wait(800);
        
        uLCD_mutex.lock();
        uLCD.locate(0,5);
        uLCD.printf(" SPOOKY!");
        uLCD_mutex.unlock();
        Thread::wait(800);
        
        uLCD_mutex.lock();
        uLCD.locate(0,5);
        uLCD.printf("  SPOOKY!");
        uLCD_mutex.unlock();
        Thread::wait(800);
        
       
       
        
        
    }
}
