#include "mbed.h"
#include "LSM9DS1.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#define PI 3.14159
// Earth's magnetic field varies by location. Add or subtract
// a declination to get a more accurate heading. Calculate
// your's here:
// http://www.ngdc.noaa.gov/geomag-web/#declination
#define DECLINATION -4.94 // Declination (degrees) in Atlanta,GA.

DigitalOut myled(LED1);
DigitalIn sel(p21);
Serial pc(USBTX, USBRX);
Serial device(p13, p14); 
uLCD_4DGL uLCD(p27,p28,p30); // serial tx, serial rx, reset pin;
SDFileSystem sd(p5, p6, p7, p8, "sd");
//Global variables. Whatever. Sue me. 
float oldx = 0;
float oldy = 0;


// Calculate pitch, roll, and heading.
// Pitch/roll calculations taken from this app note:
// http://cache.freescale.com/files/sensors/doc/app_note/AN3461.pdf?fpsp=1
// Heading calculations taken from this app note:
// http://www51.honeywell.com/aero/common/documents/myaerospacecatalog-documents/Defense_Brochures-documents/Magnetic__Literature_Application_notes-documents/AN203_Compass_Heading_Using_Magnetometers.pdf
void printAttitude(float ax, float ay, float az, float mx, float my, float mz)
{
    float roll = atan2(ay, az);
    float pitch = atan2(-ax, sqrt(ay * ay + az * az));
// touchy trig stuff to use arctan to get compass heading (scale is 0..360)
    mx = -mx;
    float heading;
    if (my == 0.0)
        heading = (mx < 0.0) ? 180.0 : 0.0;
    else
        heading = atan2(mx, my)*360.0/(2.0*PI);
    //pc.printf("heading atan=%f \n\r",heading);
    heading -= DECLINATION; //correct for geo location
    if(heading>180.0) heading = heading - 360.0;
    else if(heading<-180.0) heading = 360.0 + heading;
    else if(heading<0.0) heading = 360.0  + heading;


    // Convert everything from radians to degrees:
    //heading *= 180.0 / PI;
    pitch *= 180.0 / PI;
    roll  *= 180.0 / PI;
    if (sel){
        pc.printf("Pitch: %f,    Roll: %f degress\n\r",pitch,roll);
        pc.printf("Magnetic Heading: %f degress\n\r",heading); 
    }
    else{
        device.printf("Pitch: %f,    Roll: %f degress\n\r",pitch,roll);
        device.printf("Magnetic Heading: %f degress\n\r",heading);
    } 
    
}

void bubLev(float ax, float ay, float az, float oldx, float oldy){
    uLCD.filled_circle(oldx, oldy, 5, BLACK);   
    uLCD.filled_circle(floor(-ax/az*40.0)+63, floor(-ay/az*40.0)+63, 5, 0xFF00FF);    
    oldx = floor(ax/az*40)+63;
    oldy = floor(ay/az*40)+63;
}




int main()
{
    //device.baud(19200);
    //device.format(8N1);
    
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello SD File World!\n Mike and Gedeon Lab 2.\n");
    fclose(fp); 
    
    char myString [100];
    
    FILE *fr = fopen("/sd/mydir/sdtest.txt", "r");
    if (fgets(myString, 100, fr) != NULL){
        pc.printf("%s\n", myString);
    }
    fclose(fr);
    wait(2);

    LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
    sel.mode(PullUp);
    uLCD.baudrate(3000000);
    IMU.begin();
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);
    IMU.calibrateMag(0);
    uLCD.filled_circle(63, 63, 40, 0x0000FF);
    while(1) {
        while(!IMU.tempAvailable());
        IMU.readTemp();
        while(!IMU.magAvailable(X_AXIS));
        IMU.readMag();
        while(!IMU.accelAvailable());
        IMU.readAccel();
        while(!IMU.gyroAvailable());
        IMU.readGyro();
        if (sel){
            pc.printf("\nIMU Temperature = %f C\n\r",25.0 + IMU.temperature/16.0);
            pc.printf("        X axis    Y axis    Z axis\n\r");
            pc.printf("gyro:  %9f %9f %9f in deg/s\n\r", IMU.calcGyro(IMU.gx), IMU.calcGyro(IMU.gy), IMU.calcGyro(IMU.gz));
            pc.printf("accel: %9f %9f %9f in Gs\n\r", IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az));
            pc.printf("mag:   %9f %9f %9f in gauss\n\r", IMU.calcMag(IMU.mx), IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));
            printAttitude(IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az), IMU.calcMag(IMU.mx),
                        IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));
        }
        else{
            device.printf("\nIMU Temperature = %f C\n\r",25.0 + IMU.temperature/16.0);
            device.printf("        X axis    Y axis    Z axis\n\r");
            device.printf("gyro:  %9f %9f %9f in deg/s\n\r", IMU.calcGyro(IMU.gx), IMU.calcGyro(IMU.gy), IMU.calcGyro(IMU.gz));
            device.printf("accel: %9f %9f %9f in Gs\n\r", IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az));
            device.printf("mag:   %9f %9f %9f in gauss\n\r", IMU.calcMag(IMU.mx), IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));
            printAttitude(IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az), IMU.calcMag(IMU.mx),
                        IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));
        }
        
        bubLev(IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az), oldx, oldy);
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }
}
