/**
 * This program reads in the state of the external DIP switch
 * and outputs it to the LED using the MCP23S17 I/O expander chip
 *
 * @author(s): Gedeon Nyengele & Mike Bossi
 * @date: 01/29/2016
 */
#include "mbed.h"
#include "wdt.h"
#include "MCP23S17.h"
#include "Nav_Switch.h"
#include "mpr121.h"


DigitalOut LED_1(p21);
PwmOut LED_2(p22);
DigitalIn switch1(p23);
DigitalIn switch2(p24);
DigitalIn switch3(p25);
DigitalIn switch4(p26);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


InterruptIn interrupt(p27);

I2C i2c(p9, p10);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    // LED demo mod by J. Hamblen
    //pc.printf("MPR value: %x \r\n", value);
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
        }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
}

// Create an SPI bus
    SPI spi(p5, p6, p7);

    // Device opcode, as defined in datasheet


    // Read switch state and show state on LED
    // Assumption: Switch connected to GPB0 (MCP23S17 pin 1)
    //             LED connected to GPA0 (MCP23S17 pin 21)

Watchdog wdt;
BusIn _pins(p28, p29, p30);

int main()
{
    
    _pins.mode(PullUp);
    Nav_Switch myNav( p18, p15, p16, p19, p17);
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    char Opcode = 0x40;

    MCP23S17 chip(spi, p20, Opcode);

    // Set PORT_A pins to be output pins
    chip.direction(PORT_A, 0x00);

    // Set PORT_B pins to be input pins
    chip.direction(PORT_B, 0xFF);
    wdt.kick(5.0); 
    int switch_1 = 0;
    int switch_2 = 0;
    int switch_3 = 0;
    
  //  int switch_4 = 0;
    short lockUpCount = 0;
    
    switch3.mode(PullUp);
    switch4.mode(PullUp);
    
    wait(.45);
    
   
   while(1){
        
        
        wdt.kick();
        
        if(!switch4){
            lockUpCount++;
            if (lockUpCount > 100)
                while(1) {}   
        }
        
        
        switch (_pins){
            case 0x7:
                if(!switch1)
                    LED_1 = 1;
                 else
                    LED_1 = 0;
            
                switch_1 = switch1.read();
                switch_2 = switch2.read();
                switch_3 = switch3.read();
        
                LED_2 = !switch_1*0.25 + !switch_2 * 0.40 + !switch_3*0.35;
            break;
            
            case 0x6:
                chip.write(PORT_A, chip.read(PORT_B) & 0x01);
            break;
            
            case 0x5:
                mbedleds = ~(myNav & 0x0F); //update leds with nav switch direction inputs
                if(myNav.fire()) mbedleds = 0x0F;
            break;
            
            }
        
        wait(0.05);
    }
    
}

