#include "mbed.h"

//----------------------------
//Watchdog class
class Watchdog {
public:

    //Directions on how to use this stuff can be found in the lpc1768 user manual. 
    //LPC_WDT is the "Register set", -> is the register, 0x is the hex value to write
    //Can also use 0B to write binary, or just base 10 by =
    //Chip has multiple clock sources, critical to understand for low power modes. This WDT uses the main system clock

    void kick(float timeToReset) {
        LPC_WDT->WDCLKSEL = 0x1;                
        uint32_t clk = SystemCoreClock / 16;    
        LPC_WDT->WDTC = timeToReset * (float)clk;
        LPC_WDT->WDMOD = 0x3;                  
        kick();
    }
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

//--------------------------------------
/*Insert in code
Watchdog wdt; //Create object



byte lockUpCounter = 0; //Simulate a lockup, use a byte because ti consumes less memory


if (lockUpCounter > 100){ //Simulated lockup
    while(1);
    }
lockUpCounter++;

wdt.kick; //Reset WDT

//------------------------------------
// Assembly stuff

//Attach file
//extern "C" int my_asm(int value);
//my_asm(value);
//----------------
//Thisw goes in separate ASM file

*/