/*
説明
Nucleo-F303K8とTWE-Liteを使った無線送信のサンプル

以下ピン配置
Nucleo     TWE-Lite
GND--------GND&M1--------------------------0V
+3V3-------VCC&AI1&AI2&AI3&AI4
PA_9-------3
PA_10------10

*/


#include "mbed.h"

Serial pc(USBTX, USBRX);
Serial TWE(PA_9, PA_10);
Timer timer;

char data[]="Hello World!!\r\n";

int main() {
  TWE.baud(115200);
  timer.reset();
  timer.start();
 
  while(1){
    double t = timer.read();
    TWE.printf("time:%f,%s\r\n",t,data);
    wait(1);
  }
}//main
