#include "mbed.h"
#include "string"
#include "GPS.h"

GPS::GPS(PinName tx, PinName rx) : gps(tx,rx){
  gps.baud(115200);
  gps.printf("$PMTK251,9600*17\r\n");
  wait(0.5);
  gps.baud(9600);
  gps.printf("$PMTK314,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*28\r\n");
  wait(0.5);
};

void GPS::rateUP(){
  gps.baud(9600);
  gps.printf("$PMTK251,115200*1F\r\n");
  wait(0.5);
  gps.baud(115200);
  gps.printf("$PMTK220,100*2F\r\n");
  wait(0.5);
  gps.printf("$PMTK300,00,0,0,0,0*2C\r\n");
  wait(0.5);
  gps.printf("$PMTK251,115200*1F\r\n");
}


void GPS::getGPS(){
  gps_data[cnt_gps] = gps.getc();
  
  if(gps_data[cnt_gps] == '$' || cnt_gps ==256){
    cnt_gps = 0;
    memset(gps_data,'\0',256);
  }else if(gps_data[cnt_gps] == '\r'){
    float world_time, lon_east, lat_north;
    int rlock, sat_num;
    char lat,lon;
    if(sscanf(gps_data,"GPGGA,%f,%f,%c,%f,%c,%d,%d",&world_time,&lat_north,&lat,&lon_east,&lon,&rlock,&sat_num)>=1){
      if(rlock==1){
        lat_north = DMS2DEG(lat_north);
        lon_east = DMS2DEG(lon_east);
        debug->printf("%s\n",gps_data);
        debug->printf("Lat:%f,Lon%f\r\ntime:%f,sat_num:%d\r\n",lat_north,lon_east,world_time,sat_num);
      }else{
        debug->printf("%s\n",gps_data);
      }
    }
  }else{
    cnt_gps++;
  }
}

void GPS::LogStart(PinName tx, PinName rx){
  debug = new Serial(tx, rx);
  debug->printf("gps log start!!\r\n");
  gps.attach(this,&GPS::getGPS,Serial::RxIrq);
}

float GPS::DMS2DEG(float raw_data){
        int d = (int)(raw_data/100);
        float m = (raw_data - (float)d*100);
        return (float)d + m/60;
} 