#include "mbed.h"

DigitalOut Led1(LED1);
DigitalOut Led2(LED2);
DigitalOut Led3(LED3);
DigitalOut Led4(LED4);
DigitalIn SW2(p15);             //up
DigitalIn SW3(p12);             //down
DigitalIn SW4(p16);             //right
InterruptIn  SW1(p14);          //center

bool pressed =false;

enum State {ST_AUS = 0, ST_EIN};

State state;

void rise(void)
{
    pressed =true;
}

bool CheckFlag()
{
    if (pressed) {
        pressed = false;
        return true;
    }
    return false;
}


void blink(void)
{
    for(int i=0; i<4; i++) {
        if(i<4)
            Led4=!Led4;
    }
}

void ST_Ein(void)
{
    while(true) {
        Led1 =1;
        blink();

        if(CheckFlag()) {
            state = ST_AUS;
            return;
        }
    }
}

void ST_Aus(void)
{
    while(true) {
        Led1 =0;
        if (CheckFlag()) {
            state = ST_EIN;
            return;
        }
    }
}

void stateMachine();




int main()
{

    SW1.rise(&rise);
    while(1) {
        stateMachine();
    }

}

void stateMachine()
{
    switch (state) {
        case ST_AUS:
            ST_Aus();
            break;
        case ST_EIN:
            ST_Ein();
            break;
            //default: ST_Error();
            // break;
    }
}