#include "mbed.h"

// PC_12: DIN, PC_10: CLK, PA_15: LOAD/CS
SPI max72_spi(PC_12, NC, PC_10);
DigitalOut load(PA_15);

// define registros de matriz MAX7219
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define LOW 0
#define HIGH 1
#define MHZ 1000000

void maxSingle( int reg, int col) {
//maxSingle es la funcion facil para usar una sola matriz max7219
    load = LOW;            // comienza
    max72_spi.write(reg);  // especifica registro
    max72_spi.write(col);  // coloca datos
    load = HIGH;           // acegura que los datos estan cargados(en el cambio en alto de LOAD/CS)
}

void setup () {
    // iniciacion de la matriz MAX7219
    // configuracion SPI : 8 bits, modo 0
    max72_spi.format(8, 0);

    // frecuencia MAX7219(10 MHZ)
    
    maxSingle(max7219_reg_scanLimit, 0x07);
    maxSingle(max7219_reg_decodeMode, 0x00);  // usando una matriz led (sin digitos)
    maxSingle(max7219_reg_shutdown, 0x01);    // no para modo apagado
    maxSingle(max7219_reg_displayTest, 0x00); // no test de display
    for (int e=1; e<=8; e++) {    // registros vacios, apaga todos los LEDs
        maxSingle(e,0);
    }
    maxSingle(max7219_reg_intensity, 0x03 & 0x0f);    // con el primer registro se cambia intensidad luminica de la matriz. rango: 0x00 a 0x0f
}
int t;
int main() {
    setup ();
    while (1){
     if(t<=200)
       {
     maxSingle(1,255);                      //columna 1 
     maxSingle(2,129);                      //columna 2
     maxSingle(3,129);                       //columna 3
     maxSingle(4,129);                       //columna 4
     maxSingle(5,129);                      //columna 5
     maxSingle(6,129);                      //columna 6
     maxSingle(7,129);                      //columna 7
     maxSingle(8,255);                     //columna 8
       }
       else if(t>=201&&t<=400)
       {
     maxSingle(1,0);                      //columna 1 
     maxSingle(2,126);                      //columna 2
     maxSingle(3,66);                       //columna 3
     maxSingle(4,66);                       //columna 4
     maxSingle(5,66);                      //columna 5
     maxSingle(6,66);                      //columna 6
     maxSingle(7,126);                      //columna 7
     maxSingle(8,0);
       } 
       else if(t>=401&&t<=600)
       {
 
     maxSingle(1,0);                      //columna 1 
     maxSingle(2,0);                      //columna 2
     maxSingle(3,60);                       //columna 3
     maxSingle(4,36);                       //columna 4
     maxSingle(5,36);                      //columna 5
     maxSingle(6,60);                      //columna 6
     maxSingle(7,0);                      //columna 7
     maxSingle(8,0);                     //columna 8
        
       } 
       else if(t>=601&&t<=800)
       {
     maxSingle(1,0);                      //columna 1 
     maxSingle(2,0);                      //columna 2
     maxSingle(3,0);                       //columna 3
     maxSingle(4,24);                       //columna 4
     maxSingle(5,24);                      //columna 5
     maxSingle(6,0);                      //columna 6
     maxSingle(7,0);                      //columna 7
     maxSingle(8,0);                     //columna 8 
            
       } 
       else if(t>=801&&t<=1000)
       {
     maxSingle(1,0);                      //columna 1 
     maxSingle(2,0);                      //columna 2
     maxSingle(3,60);                       //columna 3
     maxSingle(4,36);                       //columna 4
     maxSingle(5,36);                      //columna 5
     maxSingle(6,60);                      //columna 6
     maxSingle(7,0);                      //columna 7
     maxSingle(8,0);                     //columna 8
            
       } 
       else if(t>=1001&&t<=1200)
       {

     maxSingle(1,0);                      //columna 1 
     maxSingle(2,126);                      //columna 2
     maxSingle(3,66);                       //columna 3
     maxSingle(4,66);                       //columna 4
     maxSingle(5,66);                      //columna 5
     maxSingle(6,66);                      //columna 6
     maxSingle(7,126);                      //columna 7
     maxSingle(8,0);
      
       } 
       else if(t>=12001&&t<=16000)
       {
     
     maxSingle(1,255);                      //columna 1 
     maxSingle(2,129);                      //columna 2
     maxSingle(3,129);                       //columna 3
     maxSingle(4,129);                       //columna 4
     maxSingle(5,129);                      //columna 5
     maxSingle(6,129);                      //columna 6
     maxSingle(7,129);                      //columna 7
     maxSingle(8,255);                     //columna 8 
     
           }
      else if(t>=1601&&t<=1800)
       {
     maxSingle(1,255);                      //columna 1 
     maxSingle(2,129);                      //columna 2
     maxSingle(3,129);                       //columna 3
     maxSingle(4,129);                       //columna 4
     maxSingle(5,129);                      //columna 5
     maxSingle(6,129);                      //columna 6
     maxSingle(7,129);                      //columna 7
     maxSingle(8,255);                     //columna 8 
                
           }
           
        else{
            }
            
     t=t+1;
     if(t>=1800)
     t=0;
     else{}
     }
}