#include "mbed.h"
#include "max7219.h"

// PC_12: DIN, PC_10: CLK, PA_15: LOAD/CS
SPI max72_spi(PC_12, NC, PC_10);
DigitalOut load(PA_15);

// define registros de matriz MAX7219
#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08
#define max7219_reg_decodeMode   0x09
#define max7219_reg_intensity    0x0a
#define max7219_reg_scanLimit    0x0b
#define max7219_reg_shutdown     0x0c
#define max7219_reg_displayTest  0x0f

#define LOW 0
#define HIGH 1
#define MHZ 1000000

void maxSingle( int reg, int col) {
//maxSingle es la funcion facil para usar una sola matriz max7219
    load = LOW;            // comienza
    max72_spi.write(reg);  // especifica registro
    max72_spi.write(col);  // coloca datos
    load = HIGH;           // acegura que los datos estan cargados(en el cambio en alto de LOAD/CS)
}

void setup () {
    // iniciacion de la matriz MAX7219
    // configuracion SPI : 8 bits, modo 0
    max72_spi.format(8, 0);

    // frecuencia MAX7219(10 MHZ)
    
    maxSingle(max7219_reg_scanLimit, 0x07);
    maxSingle(max7219_reg_decodeMode, 0x00);  // usando una matriz led (sin digitos)
    maxSingle(max7219_reg_shutdown, 0x01);    // no para modo apagado
    maxSingle(max7219_reg_displayTest, 0x00); // no test de display
    for (int e=1; e<=8; e++) {    // registros vacios, apaga todos los LEDs
        maxSingle(e,0);
    }
    maxSingle(max7219_reg_intensity, 0x00 & 0x0f);    // con el primer registro se cambia intensidad luminica de la matriz. rango: 0x00 a 0x0f
}
int t;
int main() {
    setup ();
    while (1){
     if(t<=2000)
       {
     maxSingle(1,0);                      //columna 1 
     maxSingle(2,0);                      //columna 2
     maxSingle(3,0);                       //columna 3
     maxSingle(4,0);                       //columna 4
     maxSingle(5,0);                      //columna 5
     maxSingle(6,0);                      //columna 6
     maxSingle(7,0);                      //columna 7
     maxSingle(8,0);                     //columna 8
      
       }
       else if(t>=2001&&t<=4000)
       {
        maxSingle(1,8);                      //columna 1 
     maxSingle(2,16);                      //columna 2
     maxSingle(3,36);                       //columna 3
     maxSingle(4,154);                       //columna 4
     maxSingle(5,89);                      //columna 5
     maxSingle(6,36);                      //columna 6
     maxSingle(7,8);                      //columna 7
     maxSingle(8,16);                     //columna 8 
      
       } 
       else if(t>=4001&&t<=6000)
       {
       maxSingle(1,0);                      //columna 1 
     maxSingle(2,0);                      //columna 2
     maxSingle(3,0);                       //columna 3
     maxSingle(4,0);                       //columna 4
     maxSingle(5,0);                      //columna 5
     maxSingle(6,0);                      //columna 6
     maxSingle(7,0);                      //columna 7
     maxSingle(8,0);                     //columna 8  
      
       } 
       else if(t>=6001&&t<=8000)
       {
     maxSingle(1,8);                      //columna 1 
     maxSingle(2,16);                      //columna 2
     maxSingle(3,36);                       //columna 3
     maxSingle(4,154);                       //columna 4
     maxSingle(5,89);                      //columna 5
     maxSingle(6,36);                      //columna 6
     maxSingle(7,8);                      //columna 7
     maxSingle(8,16);                     //columna 8
      
       } 
       else if(t>=8001&&t<=10000)
       {
        maxSingle(1,0);                      //columna 1 
     maxSingle(2,0);                      //columna 2
     maxSingle(3,0);                       //columna 3
     maxSingle(4,0);                       //columna 4
     maxSingle(5,0);                      //columna 5
     maxSingle(6,0);                      //columna 6
     maxSingle(7,0);                      //columna 7
     maxSingle(8,0);                     //columna 8 
      
       } 
       else if(t>=10001&&t<=12000)
       {
        maxSingle(1,8);                      //columna 1 
     maxSingle(2,16);                      //columna 2
     maxSingle(3,36);                       //columna 3
     maxSingle(4,154);                       //columna 4
     maxSingle(5,89);                      //columna 5
     maxSingle(6,36);                      //columna 6
     maxSingle(7,8);                      //columna 7
     maxSingle(8,16);                     //columna 8 
      
       } 
       else if(t>=12001&&t<=16000)
       {
        maxSingle(1,255);                      //columna 1 
     maxSingle(2,255);                      //columna 2
     maxSingle(3,255);                       //columna 3
     maxSingle(4,255);                       //columna 4
     maxSingle(5,255);                      //columna 5
     maxSingle(6,255);                      //columna 6
     maxSingle(7,255);                      //columna 7
     maxSingle(8,255);                     //columna 8
           }
           
       else
       {
           }
     t=t+1;
     if(t>=16000)
     t=0;
     else{}
     }
}