
#ifndef PROJECT_DEFINES_H_
#define PROJECT_DEFINES_H_

/******************************************************************************/
/*************************** PIN DEFINITION ***********************************/
/******************************************************************************/

// Switches, buttons and digital sensors
#define ENTER_SW_PIN                            PA_15
#define LIMIT_SW_01_PIN                         PB_7
#define INSPIRATION_VALVE_HALL_01_PIN           PA_10     
#define INSPIRATION_VALVE_HALL_02_PIN           PB_3
#define EXPIRATION_VALVE_HALL_01_PIN            PA_9
#define EXPIRATION_VALVE_HALL_02_PIN            PC_7

// Rotary encoder
#define ENCODER_A_SIGNAL                        PA_13
#define ENCODER_B_SIGNAL                        PA_14
 
//Nextion display
#define NEXTION_DISPLAY_TX_PIN                  PC_10
#define NEXTION_DISPLAY_RX_PIN                  PC_11

// Pressure sensors
#define PRESSURE_SENSOR_01_SCL_PIN              PB_10
#define PRESSURE_SENSOR_01_SDA_PIN              PB_11
#define PRESSURE_SENSOR_02_SCL_PIN              PB_8
#define PRESSURE_SENSOR_02_SDA_PIN              PB_9


// Stepper motor
#define STEPPER_PULSE_PIN                       PC_8
#define STEPPER_ENABLE_PIN                      PC_6
#define STEPPER_DIRECTION_PIN                   PC_5
#define STEPPER_PULSE_FEEDBACK_PIN              PA_12

// Electric valves
#define INSPIRATION_VALVE_IA_PIN                PB_5
#define INSPIRATION_VALVE_IB_PIN                PB_4
#define INSPIRATION_VALVE_EN_PIN                PA_8 
#define EXPIRATION_VALVE_IA_PIN                 PB_6
#define EXPIRATION_VALVE_IB_PIN                 PA_7 
#define EXPIRATION_VALVE_EN_PIN                 PA_6 


/******************************************************************************/
/************************* CONSTANTS AND MACROS *******************************/
/******************************************************************************/

// ------------------ Defines for the switches and buttons ---------------------

#define ENTER_SW                                0
#define LIMIT_SW_01                             1
#define INSPIRATION_VALVE_HALL_01               2    
#define INSPIRATION_VALVE_HALL_02               3
#define EXPIRATION_VALVE_HALL_01                4
#define EXPIRATION_VALVE_HALL_02                5

// ----------------- Defines for the encoder user interface --------------------

#define ENCODER_THRESHOLD                       8

#define PARAMETER_SELECTION_INDEX_LIMIT         3
#define VOLUME_SETPOINT_INDEX_LIMIT             11
#define RESP_FREQUENCY_INDEX_LIMIT              21
#define I_E_RATIO_INDEX_LIMIT                   5

#define PARAMETER_SELECTION_INDEX_DEFAULT       0
#define VOLUME_SETPOINT_INDEX_DEFAULT           5
#define RESP_FREQUENCY_INDEX_DEFAULT            10
#define I_E_RATIO_INDEX_DEFAULT                 2

// ------------- Defines for the Nextion display user interface ----------------

#define NEXTION_DISPLAY_BAUD_RATE               250000

#define BLACK                                   0x0000
#define BLUE                                    0x001F
#define BROWN                                   0xBC40
#define GREEN                                   0x07E0
#define YELLOW                                  0xFFE0
#define RED                                     0xF800
#define GRAY                                    0x8430
#define WHITE                                   0xFFFF
#define DARK_BLUE                               0x218F

#define NORMAL_COLOR                            WHITE
#define SELECT_COLOR                            BLUE
#define ADJUST_COLOR                            GREEN
#define BACKGROUND_COLOR                        BLACK
#define WAVEFORM_BACKGROUND_COLOR               DARK_BLUE     

#define VOLUME_SETPOINT_VALUE_DEFAULT           500
#define RESP_FREQUENCY_VALUE_DEFAULT            20
#define INSPIRATION_TIME_VALUE_DEFAULT          1.0
#define EXPIRATION_TIME_VALUE_DEFAULT           2.0

#define VOLUME_SETPOINT_MINIMUM_VALUE           250
#define VOLUME_SETPOINT_STEP                    50

#define MAIN_SCREEN_DEFAULT_STATE               Main_Screen_Cursor_Disable

#define VOLUME_WAVEFORM_X0                      200
#define VOLUME_WAVEFORM_Y0                      3
#define VOLUME_WAVEFORM_WIDTH                   400
#define VOLUME_WAVEFORM_HEIGHT                  157
#define VOLUME_WAVEFORM_OFFSET                  79
#define VOLUME_WAVEFORM_GAIN                    0.5

#define FLOW_WAVEFORM_X0                        200
#define FLOW_WAVEFORM_Y0                        162
#define FLOW_WAVEFORM_WIDTH                     400
#define FLOW_WAVEFORM_HEIGHT                    157
#define FLOW_WAVEFORM_OFFSET                    79
#define FLOW_WAVEFORM_GAIN                      5.0

#define PRESSURE_WAVEFORM_X0                    200
#define PRESSURE_WAVEFORM_Y0                    321
#define PRESSURE_WAVEFORM_WIDTH                 400
#define PRESSURE_WAVEFORM_HEIGHT                157
#define PRESSURE_WAVEFORM_OFFSET                0
#define PRESSURE_WAVEFORM_GAIN                  157

// ---------------------- Defines for pressure sensors -------------------------

#define PRESSURE_SENSOR_I2C_CLK_HZ                      200000

#define PRESSURE_SENSOR_01_SLAVE_ADDRESS                0x28
#define PRESSURE_SENSOR_01_SWA                          (PRESSURE_SENSOR_01_SLAVE_ADDRESS << 1)
#define PRESSURE_SENSOR_01_SRA                          (PRESSURE_SENSOR_01_SWA  | 1)

#define PRESSURE_SENSOR_02_SLAVE_ADDRESS                0x28
#define PRESSURE_SENSOR_02_SWA                          (PRESSURE_SENSOR_02_SLAVE_ADDRESS << 1)
#define PRESSURE_SENSOR_02_SRA                          (PRESSURE_SENSOR_02_SWA  | 1)

#define PRESSURE_SENSOR_OUTPUT_MAX                      14745
#define PRESSURE_SENSOR_OUTPUT_MIN                      1638
#define PRESSURE_SENSOR_PRESSURE_MAX                    1.0f
#define PRESSURE_SENSOR_PRESSURE_MIN                    0.0f

#define PRESSURE_SENSOR_01_OFFSET_PSI                   0.0f
#define PRESSURE_SENSOR_02_OFFSET_PSI                   0.0f

#define VOLUME_DISPLAY_THRESHOLD                        0.1f
#define FLOW_DISPLAY_THRESHOLD                          0.01f
#define PRESSURE_DISPLAY_THRESHOLD                      0.001f

#define PSI_TO_CMH2O_CONSTANT                           70.306957829636f
#define SPIROMETER_SENSOR_CONSTANT_OXYGEN               36.1f
#define SPIROMETER_SENSOR_CONSTANT_AIR                  (SPIROMETER_SENSOR_CONSTANT_OXYGEN * 1.08006)
#define VOLUME_CORRECTION_FACTOR                        34.4409727f

// ----------------------- Defines for digital filters -------------------------

#define P1_LPF_CUTOFF_FREQ_HZ                           20.0f
#define P1_LPF_RC_CONSTANT_SEC                          (1/(6.2832*P1_LPF_CUTOFF_FREQ_HZ))

#define P2_LPF_CUTOFF_FREQ_HZ                           20.0f
#define P2_LPF_RC_CONSTANT_SEC                          (1/(6.2832*P2_LPF_CUTOFF_FREQ_HZ))

#define F_HPF_CUTOFF_FREQ_HZ                            0.01f
#define F_HPF_RC_CONSTANT_SEC                           (1/(6.2832*F_HPF_CUTOFF_FREQ_HZ))

#define PRESSURE_01_LPF_N                               4
#define PRESSURE_02_LPF_N                               4
#define FLOW_HPF_N                                      3
#define FLOW_LPF_N                                      25

// -------------------- Defines for the stepper motor driver -------------------

#define TO_HOME                                         0
#define TO_AIRBAG                                       1
#define STEPPER_ENABLED                                 0
#define STEPPER_DISABLED                                1                                 
                
#define STEPPER_DRIVER_PULSE_MIN_PERIOD_US              100     
#define STEPPER_DRIVER_PULSE_HOME_PERIOD_US             1000  
#define STEPPER_DRIVER_DEFAULT_PULSE_PERIOD_US          1000  
 
#define STEPPER_DRIVER_MAX_PULSES                       200    
#define STEPPER_DRIVER_INSPIRATION_PULSES_DEFAULT       2000
   
#define STEPPER_DRIVER_DEFAULT_STATE                    Stepper_Driver_Home_Ramp

#define STEPPER_CALIBRATION_FREQUENCY_HZ                200
#define STEPPER_MAX_FREQUENCY_HZ                        3000


// -------------------- Defines for the electric valves ------------------------
#define INSPIRATION_VALVE_IA                            0
#define INSPIRATION_VALVE_IB                            1
#define INSPIRATION_VALVE_EN                            2 
#define EXPIRATION_VALVE_IA                             3
#define EXPIRATION_VALVE_IB                             4 
#define EXPIRATION_VALVE_EN                             5

#define INSPIRATION_VALVE_IS_OPEN                   (!(buttons & (1 << INSPIRATION_VALVE_HALL_02)))
#define INSPIRATION_VALVE_IS_CLOSED                 (!(buttons & (1 << INSPIRATION_VALVE_HALL_01)))
#define EXPIRATION_VALVE_IS_OPEN                    (!(buttons & (1 << EXPIRATION_VALVE_HALL_01)))
#define EXPIRATION_VALVE_IS_CLOSED                  (!(buttons & (1 << EXPIRATION_VALVE_HALL_02))) 

#define INSPIRATION_VALVE_ENABLE()                  valve_control = valve_control | (1 << INSPIRATION_VALVE_EN)
#define INSPIRATION_VALVE_DISABLE()                 valve_control = valve_control & ~(1 << INSPIRATION_VALVE_EN)
#define INSPIRATION_VALVE_STOP()                    valve_control = valve_control & ~((1 << INSPIRATION_VALVE_IA) | (1 << INSPIRATION_VALVE_IB))        
#define INSPIRATION_VALVE_OPEN()                    valve_control = valve_control | (1 << INSPIRATION_VALVE_IA)
#define INSPIRATION_VALVE_CLOSE()                   valve_control = valve_control | (1 << INSPIRATION_VALVE_IB) 
#define EXPIRATION_VALVE_ENABLE()                   valve_control = valve_control | (1 << EXPIRATION_VALVE_EN) 
#define EXPIRATION_VALVE_DISABLE()                  valve_control = valve_control & ~(1 << EXPIRATION_VALVE_EN)            
#define EXPIRATION_VALVE_STOP()                     valve_control = valve_control & ~((1 << EXPIRATION_VALVE_IA) | (1 << EXPIRATION_VALVE_IB))        
#define EXPIRATION_VALVE_OPEN()                     valve_control = valve_control | (1 << EXPIRATION_VALVE_IB)
#define EXPIRATION_VALVE_CLOSE()                    valve_control = valve_control | (1 << EXPIRATION_VALVE_IA)  


// ---------------------- Time period for every action -------------------------

#define DEBOUNCE_PERIOD_MS                              10
#define ENCODER_READ_PERIOD_MS                          10
#define PRESSURE_SENSOR_READ_PERIOD_MS                  10
#define SENSOR_WAVEFORM_PLOT_PERIOD_MS                  25
#define SENSOR_DISPLAY_PERIOD_MS                        500

#endif
