
#ifndef NEXTION_INTERFACE_H_
#define NEXTION_INTERFACE_H_

/* File inclusion */
#include "mbed.h"
#include "stdint.h"

/* Object declaration */

// Serial port for nextion
extern Serial  nextion_display;

// For testing purposes only
//extern Serial pc;

/* Global variable declaration */
extern uint16_t volume_setpoint_display;
extern uint16_t volume_measured_display;
extern uint8_t resp_frequency_display;
extern float   inspiration_time_display;
extern float   expiration_time_display;
extern uint8_t pressure_measured_display;

extern uint16_t selection_box_coordinates[3][4];
extern float i_e_ratio_display_table[I_E_RATIO_INDEX_LIMIT][2];


/* Function declaration */

void Nextion_Interface_Initialize(void);
void Parameter_Selection_Box_Update(void);
void Parameter_Selection_Box_Remove(void);
void Volume_Setpoint_Display_Update(void);
void Volume_Setpoint_Fix(void);
void Resp_Frequency_Display_Update(void);
void Resp_Frequency_Fix(void);
void I_E_Ratio_Display_Update(void);
void I_E_Ratio_Fix(void);

void Volume_Display_Update(void);
void Pressure_Display_Update(void);
void Flow_Display_Update(void);

void Nextion_Plot_Volume_Waveform(void);
void Nextion_Plot_Flow_Waveform(void);
void Nextion_Plot_Pressure_Waveform(void);


#endif